package cn.com.duiba.cloud.order.center.api.model.param.order;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 订单查询参数
 * @Author dangcang
 * @Date 2021/11/10 3:05 下午
 **/
@Data
public class OrderQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = 8035926659649749486L;

    /**
     * 订单编号
     */
    private Long orderCode;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 下单开始时间 毫秒级时间戳
     */
    private Long orderStartTime;

    /**
     * 下单截止时间 毫秒级时间戳
     */
    private Long orderEndTime;

    /**
     * 订单来源
     */
    private Long OrderSource;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单状态
     */
    private Integer orderStatus;
}