package cn.com.duiba.cloud.order.center.api.model.param.aftersale;

import cn.com.duiba.cloud.order.center.api.enums.AfterSaleTypeEnum;
import lombok.Data;

import java.io.Serializable;

;

/**
 * @Description 申请售后
 * @Author dangcang
 * @Date 2021/11/11 10:00 上午
 **/
@Data
public class CreateAfterSaleParam implements Serializable {

    private static final long serialVersionUID = -386661956441466429L;
    /**
     * 订单编号
     */
    private Long orderCode;


    /**
     * 子订单序号
     */
    private Integer orderSort;

    /**
     * 售后类型
     * @see cn.com.duiba.cloud.order.center.api.enums.AfterSaleTypeEnum
     */
    private Integer afterSaleType;

    /**
     * 售后方式
     * @see cn.com.duiba.cloud.order.center.api.enums.AfterSaleWayEnum
     */
    private Integer afterSaleWay;

    /**
     * 物流单号
     */
    private String logisticsNo;

    /**
     * 售后原因
     */
    private String afterSaleReason;

    /**
     * 售后凭证
     */
    private String imgSrc;

}