package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 支付信息--支付回调以后才会有
 * @Author dangcang
 * @Date 2021/11/10 2:21 下午
 **/
@Data
public class PayParam implements Serializable {

    private static final long serialVersionUID = -8904156331571769018L;
    /**
     * 支付方式
     */
    private Integer payType;

    /**
     * 支付批次
     */
    private Integer paymentLevel;

    /**
     * 支付数量(法定货币单位：分，虚拟货币单位：个)
     */
    private Long payNumber;

    /**
     * 开始支付时间 毫秒级时间戳
     */
    private Long paymentStartTime;

    /**
     * 截止支付时间 毫秒级时间戳
     */
    private Long paymentEndTime;

}