package cn.com.duiba.cloud.physical.goods.service.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 实物订单状态枚举类
 * @Author dangcang
 * @Date 2021/11/8 2:13 下午
 **/
@Getter
public enum PhysicalGoodsOrderStatusEnum {


    WAIT_SHIPMENT(30,"待发货"),
    WAIT_TAKE_DELIVERY(40,"待收货"),
    ;

    private Integer status;

    private String desc;

    PhysicalGoodsOrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    private static Map<Integer, PhysicalGoodsOrderStatusEnum> map = new HashMap<Integer, PhysicalGoodsOrderStatusEnum>() {{
        for (PhysicalGoodsOrderStatusEnum statusEnum : PhysicalGoodsOrderStatusEnum.values()) {
            put(statusEnum.getStatus(), statusEnum);
        }
    }};

    private static Map<String, PhysicalGoodsOrderStatusEnum> descMap = new HashMap<String, PhysicalGoodsOrderStatusEnum>() {{
        for (PhysicalGoodsOrderStatusEnum statusEnum : PhysicalGoodsOrderStatusEnum.values()) {
            put(statusEnum.getDesc(), statusEnum);
        }
    }};

    public static PhysicalGoodsOrderStatusEnum getByStatus(Integer status) {
        return map.get(status);
    }

    public static PhysicalGoodsOrderStatusEnum getByDesc(String desc) {
        return descMap.get(desc);
    }

}