package cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.result;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * Created by dugq on 2020-03-11.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TemporaryMaterialResult extends WechatResultBean {
    private static final long serialVersionUID = -3054011539614926440L;

    /**
     * 素材类型
     */
    private String type;
    /**
     * 媒体ID
     */
    private String mediaId;
    /**
     * 上传时间
     */
    private Date createdTime;
    /**
     * 失效时间
     */
    private Date disableTime;

    /**
     * 公众号ID
     */
    private Long oaId;


    public static TemporaryMaterialResult buildResponseError(){
        TemporaryMaterialResult wechatResultBean = new TemporaryMaterialResult();
        wechatResultBean.setErrCode(-7L);
        wechatResultBean.setErrMsg("请求结果并非期望值");
        return wechatResultBean;
    }

    public static TemporaryMaterialResult paramError(){
        TemporaryMaterialResult wechatResultBean = new TemporaryMaterialResult();
        wechatResultBean.setErrCode(-5L);
        wechatResultBean.setErrMsg("参数错误");
        return wechatResultBean;
    }

    public static TemporaryMaterialResult httpError(){
        TemporaryMaterialResult wechatResultBean = new TemporaryMaterialResult();
        wechatResultBean.setErrCode(-6L);
        wechatResultBean.setErrMsg("httpclient 发送请求时错误");
        return wechatResultBean;
    }
}
