package cn.com.duiba.duiba.qutui.center.api.remoteservice.mpAuth.openpl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.ComponentCodeTempListInfoDto;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.*;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.WxBaseResponse;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.*;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.audit.ComponentAuditStatusParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.audit.ComponentAuditSubmitParam;

import java.util.List;

/**
 * @author dugq
 * @date 2020/11/24 11:50 下午
 */
@AdvancedFeignClient
public interface RemoteComponentMpInfoService {
    /**
     * 1、在授权成功后，根据authCode获取授权公众号的AuthInfo
     * 2、根据authInfo的appId获取oa accountInfo
     * 3、保存授权公众号到数据库
     * @param authCode 授权码
     * @return 0：失败 1：成功
     */
    int saveAuthedOaInfo(String authCode);

    /**
     * 取消授权
     * @param appId 取消授权的appId
     * @return 0：失败 1：成功
     */
    int cancelAuthedOaInfo(String appId);

    /**
     * 第三方服务平台测试用例
     * 微信要求必须有。
     */
    void openPlTestCase(String authCode, String openId);


    /**
     * 根据授权公众号的appID获取账号信息
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Mini_Program_Information_Settings.html">文档详情</a>
     * @param appId 公众号ID
     * @return 账号信息
     */
    ComponentMpDetailInfoDto getMpBaseInfoByAppId(String appId);

    /**
     * 对小程序的域名进行操作，增删改查
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Server_Address_Configuration.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentDomainInfoDto modifyDomianInfo(ModifyServerDomainParam param);


    /**
     * 对小程序的域名进行操作，增删改查
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/setwebviewdomain.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentWebViewDomainInfoDto modifyWebViewDomianInfo(ModifyWebViewDomainParam param);

    /**
     * 获取订阅消息列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/subscribe_template/list_template.html">文档详情</a>
     * @param appId
     * @return
     */
    List<ComponentSubTemplateInfoDto> getTemplateList(String appId);

    /**
     * 绑定体验者
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Admin.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentBindTesterInfoDto bindTester( BindTesterParam param);

    /**
     * 解绑体验者
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/unbind_tester.html">文档详情</a>
     * @param param
     * @return
     */
    Boolean unBindTester(UnbindTesterParam param);

    /**
     * 获取体验者列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/memberauth.html">文档详情</a>
     * @param appId
     * @return
     */
    List<ComponentBindTesterInfoDto> getTesters(String appId);

    /**
     * 更新代码模版库
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Code_Template_Library_Management.html">文档详情</a>
     */
    void refreshCodeTemplate();

    /**
     * 获取代码模版列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code_template/gettemplatelist.html">文档详情</a>
     * @return
     */
    List<ComponentCodeTemplateInfoDto> getCodeTemplateList();

    /**
     * 获取各个小程序版本内容
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Code.html">文档详情</a>
     * @param param
     * @return
     */
    List<ComponentAccountVersionDto> getAccountVersionList(QueryPageAccountVersionParam param);

    /**
     * 获取某个小程序下的版本列表
     * @param appId
     * @return
     */
    List<ComponenCodeVersionDto> getCodeVersionListDto(String appId);

    /**
     * 提交代码至体验版
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/commit.html">文档详情</a>
     * @param param
     */
    void codeCommit(CodeCommitParam param);

    /**
     * 获取体验版二维码信息
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/get_qrcode.html">文档详情</a>
     * @param appId
     * @param path
     * @return
     */
    ComponentTestQRCodeDto getTestQRCode(String appId,String path);

    /**
     * 提交审核
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/submit_audit.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentAuditedDto sumitAudit(ComponentAuditSubmitParam param);

    /**
     * 审核版本代码上线
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/release.html">文档详情</a>
     * @param appId
     */
    void codeRelease(String appId);

    /**
     * 删除代码模版
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code_template/deletetemplate.html">文档详情</a>
     * @param paramBean
     */
    void deleteCodeTemplate(ComponentDelCodeTempParam paramBean);

    /**
     * 获取提交代码页面路径
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/get_page.html">文档详情</a>
     * @param appId
     * @return
     */
    List<String> getCommitCodePageList(String appId);

    /**
     * 加急审核
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/speedup_audit.html">文档详情</a>
     * @param appId
     * @return
     */
    WxBaseResponse speedAudit(String appId);

    /**
     * 取消审核
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/undocodeaudit.html">文档详情</a>
     * @param appId
     * @return
     */
    WxBaseResponse cancelAudit(String appId);

    /**
     * 获取可回退版本列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/get_history_version.html">文档详情</a>
     * @param appId
     * @return
     */
    ComponentCodeTempListInfoDto getRevertTempList(String appId);

    /**
     * 版本回退
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/revertcoderelease.html">文档详情</a>
     * @param param
     * @return
     */
    WxBaseResponse revertCodeRelease(ComponentRevertCodeReleaseParam param);

    /**
     * 查询审核状态
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/get_auditstatus.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentAuditStatusDto auditStatus(ComponentAuditStatusParam param);
}
