package cn.com.duiba.duiba.qutui.center.api.enums;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName EventLogStatusEnum.java
 * @Description TODO
 * @createTime 2021年03月25日 16:36:00
 */
public enum EventLogStatusEnum {
    JOIN(0,"参与"),
    FINISH(0,"完成"),
    ;
    private Integer code;
    private String desc;

    EventLogStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EventLogStatusEnum getEnum(Integer status) {
        if (status == null) {
            return null;
        }

        for (EventLogStatusEnum value : values()) {
            if (value.code.compareTo(status) == 0) {
                return value;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
