package cn.com.duiba.duiba.qutui.center.api.remoteservice.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.task.EventLogDto;
/**
* 参与记录 RemoteService
* @author xiaotian
* 2021-3-16 15:37:15
*/
@AdvancedFeignClient
public interface RemoteEventLogService {
    /**
    * 新增记录
    */
	Boolean save(EventLogDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(EventLogDto dto);
    /**
    * 根据id获取
    */
    EventLogDto getById(Long id);

    Boolean joinEventLog(String openId, Long staffId, Long projectId) throws BizException;

    Boolean finishEventLog(String openId, Long staffId, String project, String statisticsNum) throws BizException;


}
