package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.qutui.center.api.exception.ErrorCode;
import cn.com.duiba.duiba.qutui.center.api.util.Assert;
import lombok.Data;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ProjectMiddlePageDto.java
 * @Description TODO
 * @createTime 2021年03月21日 11:25:00
 */
@Data
public class ProjectMiddlePageDto implements Serializable {
    /**
     * 中间页形式:0:实体中间页后 1:空白中间页后
     */
    private Integer middlePageType;
    /**
     * 是否自动添加绑定关系0:否 1:是
     */
    private Integer autoBandRelation;

    public void check() throws BizException {
        Assert.isNotNull(middlePageType, ErrorCode.PARAM_ERROR, "请选择中间页形式");
        Assert.isNotNull(autoBandRelation, ErrorCode.PARAM_ERROR, "请选择绑定关系");
    }
}
