package cn.com.duiba.duiba.qutui.center.api.enums;


import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaotian on 2021/03/16.
 */
public enum ContentDeleteEnum {

    /**
     * 内容上下架状态
     */
    NOT_DELETE(0, "未删除"),
    DELETE(1, "已删除")
    ;

    private Integer code;
    private String desc;

    ContentDeleteEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ContentDeleteEnum> ENUM_MAP = new HashMap<>();

    static {
        for (ContentDeleteEnum type : values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }

    public static ContentDeleteEnum getByCode(String code) {
        ContentDeleteEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }




}
