package cn.com.duiba.duiba.qutui.center.api.enums;

import java.util.Objects;

/**
 * Created by xiaotian on 2020-02-07.
 */
public enum
DegradedTypeEnum {

    DISCARD(0,"丢弃，info日志"),
    /**
     * 打印日志后，丢弃不做任何处理
     */
    LOG(1,"丢弃，打印error日志"),
    /**
     * 插入数据库
     * 日后将会开发功能进行补发
     */
    INSERT_DB(2,"数据库记录"),
    /**
     * 发送其他类型的消息 如模版消息等等 或者其他公众号消息
     */
    OTHER_MESSAGE(3,"发送其他消息"),
    ;
    private Integer code;
    private String desc;

    DegradedTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DegradedTypeEnum getByCode(Integer code) {
        for (DegradedTypeEnum e :values())
            if (Objects.equals(code, e.getCode())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息类型");
    }


}
