package cn.com.duiba.duiba.qutui.center.api.enums;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ProjectPushTypeEnum.java
 * @Description TODO
 * @createTime 2021年03月21日 13:56:00
 */
public enum ProjectPushTypeEnum {
    POSTER(1, "海报推广"),
    URL(2, "链接推广")
    ;
    private Integer type;
    private String msg;

    ProjectPushTypeEnum(Integer type, String msg) {
        this.type = type;
        this.msg = msg;
    }

    public static ProjectPushTypeEnum getEnum(Integer type) {
        if (type == null) {
            return null;
        }

        for (ProjectPushTypeEnum value : values()) {
            if (value.type.compareTo(type) == 0) {
                return value;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }


    public String getMsg() {
        return msg;
    }

}
