package cn.com.duiba.duiba.qutui.center.api.result;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName PageResult.java
 * @Description 分页返回类
 * @createTime 2021年03月18日 17:38:00
 */
@Data
public class PageResult<T> implements Serializable {

    private List<T> list;

    private Long totalCount;

    private Integer pageNum;

    private Integer pageSize;

    public PageResult(List<T> data, Long totalCount) {
        this.list = data;
        this.totalCount = totalCount;
    }

    public PageResult(List<T> data, Long totalCount, Integer pageNum, Integer pageSize) {
        this.list = data;
        this.totalCount = totalCount;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }
}
