package cn.com.duiba.duiba.qutui.center.api.dto.mpAccounts;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 小程序表
* 2021-3-18 16:07:58
*/
@Data
public class MpAccountsDto implements Serializable {

    /**
    * 主键
    */
    private Long id;

    /**
    * 小程序名称
    */
    private String mpName;

    /**
    * 小程序的原始ID
    */
    private String sourceId;

    /**
    * 小程序的app ID
    */
    private String appId;

    /**
    * 小程序的加密字符串
    */
    private String appSecret;

    /**
    * 小程序的aes加密字符串
    */
    private String appAesKey;

    /**
    * 是否启用 1：授权 0：取消授权
    */
    private Integer mpEnable;

    /**
    * 小程序二维码地址
    */
    private String qrCode;

    /**
    * 小程序类型
    */
    private Integer oaType;

    /**
    * 备注
    */
    private String remark;

    /**
    * 优先级排序，越小越高
    */
    private Integer payLoad;

    /**
    * 接口调用凭证的刷新凭证
    */
    private String refreshToken;

    /**
    * 小程序头像地址
    */
    private String headImg;

    /**
    * 小程序类型 0:订阅号 1:由历史老帐号升级后的订阅号 2:服务号
    */
    private Integer serviceTypeInfo;

    /**
    * 小程序认证类型：-1:未认证 0:微信认证 1:新浪微博认证 2:腾讯微博认证
    */
    private Integer verifyTypeInfo;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


}

