package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.qutui.center.api.exception.ErrorCode;
import cn.com.duiba.duiba.qutui.center.api.remoteservice.setup.enums.SetupLevelEnum;
import cn.com.duiba.duiba.qutui.center.api.util.Assert;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 项目下发机构等级
* 2021-3-19 15:11:15
*/
@Data
public class ProjectPushLevelDto implements Serializable {

    /**
    * 事件id,主键，自增
    */
    private Long id;

    /**
    * 项目id
    */
    private Long projectId;

    /**
    * 推广机构等级
    */
    private Integer pushLevel;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    public void check() throws BizException {
        SetupLevelEnum setupLevelEnum = SetupLevelEnum.getSetupLevelEnum(pushLevel);
        Assert.isNotNull(setupLevelEnum, ErrorCode.PARAM_ERROR,"推广机构等级错误");
    }

}

