package cn.com.duiba.duiba.qutui.center.api.enums;

/**
 * 员工登陆类型
 * Created by xiaotian on 2020-02-12.
 */
public enum StaffIdentityEnum {
    STAFF(1,"银行员工"),
    SALESMAN(2,"业务员"),

    ;
    private Integer code;
    private String desc;

    StaffIdentityEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static StaffIdentityEnum getEnum(Integer code) {
        if (code == null) {
            return null;
        }

        for (StaffIdentityEnum value : values()) {
            if (value.code.compareTo(code) == 0) {
                return value;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
