package cn.com.duiba.duiba.qutui.center.api.param.mpAccount.operation;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/4/21
 */
@Data
public class ComponentUserLogSearchParam implements Serializable {

    private String appId;
    /**
     * YYYYMMDD格式的日期，仅支持最近7天
     */
    private String date;
    /**
     * 开始时间，必须是date指定日期的时间
     */
    private Integer beginTime;
    /**
     * 结束时间，必须是date指定日期的时间
     */
    private Integer endTime;
    /**
     * 开始返回的数据下标，用作分页，默认为0
     */
    private Integer start;
    /**
     * 返回的数据条数，用作分页，默认为20
     */
    private Integer limit;
    /**
     * 小程序启动的唯一ID，按TraceId查询会展示该次小程序启动过程的所有页面的日志。
     */
    private String traceId;
    /**
     * 小程序页面路径，例如pages/index/index
     */
    private String url;
    /**
     * 用户微信号或者OpenId
     */
    private String id;
    /**
     * 开发者通过setFileterMsg/addFilterMsg指定的filterMsg字段
     */
    private String filterMsg;
    /**
     * 日志等级，返回大于等于level等级的日志，level的定义为2（Info）、4（Warn）、8（Error），如果指定为4，则返回大于等于4的日志，即返回Warn和Error日志。
     */
    private Integer level;


}
