package cn.com.duiba.duiba.qutui.center.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.content.ContentDto;
import cn.com.duiba.duiba.qutui.center.api.param.content.ContentQuery;

import java.util.List;

/**
* 内容表 RemoteService
* @author xiaotian
* 2021-3-21 14:27:23
*/
@AdvancedFeignClient
public interface RemoteContentService {
    /**
    * 新增记录
    */
	Boolean save(ContentDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(ContentDto dto);
    /**
    * 根据id获取
    */
    ContentDto getById(Long id);

    /**
     * 获取内容列表
     * @param ids
     * @return
     */
    List<ContentDto> getList(List<Long> ids);


    /**
     * 筛选列表
     * @param contentQuery
     * @return
     */
    List<ContentDto> queryList(ContentQuery contentQuery);

    /**
     * 筛选列表数量
     * @param contentQuery
     * @return
     */
    Integer queryListCount(ContentQuery contentQuery);

}
