package cn.com.duiba.duiba.qutui.center.api.remoteservice.users;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.users.UsersDto;

import java.util.List;
import java.util.Map;

/**
* 授权用户信息表 RemoteService
* @author xiaotian
* 2021-3-16 19:24:01
*/
@AdvancedFeignClient
public interface RemoteUsersService {
    /**
    * 新增记录
    */
	Long save(UsersDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(UsersDto dto);
    /**
    * 根据id获取
    */
    UsersDto getById(Long id);

    /**
     * 通过小程序Id和用户openId获取用户信息
     * @param mpId
     * @param openId
     * @return
     */
    UsersDto getByMpIdAndOpenId(Long mpId,String openId);


    /**
     * 根据列表Id批量获取
     * @param userIds
     * @return
     */
    Map<Long,UsersDto> getByIdList(List<Long> userIds);


}
