package cn.com.duiba.duiba.qutui.center.api.util;

/**
 * redis key
 */
public enum RedisKeyFactory {

    K001("测试key"),


    KW006("jsApiTicket缓存"),

    KW007("jsApiTicket分布式锁"),

    KW008("保存第三方平台的component_verify_ticket"),
    KW009("最近推广过项目的5个员工头像:"),
    KW010("任务详情:"),
    KW011("订阅消息关键字列表"),
    K0012("获取名片scid分布式锁"),
    K0013("获取内容scid分布式锁"),
    K0014("获取任务的scid分布式锁"),
    K0015("获取活动的scid分布式锁"),
    K0016("获取名片产品的scid分布式锁"),
    K0017("获取名片活动的scid分布式锁"),
    K0018("获取名企业资讯的scid分布式锁"),
    ;

    private static final String SPACE = "QuTuiCenter";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
