package cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.customer;

import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.BaseMessageDto;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author xiaotian
 * @date 2020-02-06
 * 公众号的客服菜单消息体
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerMenuDto extends BaseMessageDto {
    private static final long serialVersionUID = 9212158969327082665L;

    /**
     * 菜单头部提示语
     */
    @NotBlank(message = "菜单头部提示语不能为空")
    private String headContent;

    /**
     * 菜单选项列表 不要自己构建塞进来，用addMenu方法
     */
    private List<JSONObject> list = new LinkedList<>();

    /**
     * 用户选择好后的提示语
     */
    @NotBlank(message = "选择结束提示语不能为空")
    private String  tailContent;

    /**
     * 追加菜单选项
     * @param id 选项唯一标志
     * @param content 选项描述
     */
    public void addMenu(String id ,String content){
        JSONObject menu = new JSONObject();
        menu.put(id, content);
        list.add(menu);
    }

}
