package cn.com.duiba.service.exception;

import cn.com.duiba.service.domain.dataobject.AppDO;

public class StatusException extends Exception {
	
	/**
	 * 其他异常
	 */
	public static final int CodeOtherException=0;
	/**
	 * 积分不足
	 */
	public static final int CodeCreditsNotEnough=1;
	/**
	 * 开发者余额不足
	 */
	public static final int CodeBalanceNotEnough=2;
	/**
	 * 月预算不足
	 */
	public static final int CodeMonthBudgetNotEnough=3;
	/**
	 * 日预算不足
	 */
	public static final int CodeDayBudgetNotEnough=4;
	/**
	 * 库存不足
	 */
	public static final int CodeStockNotEnough=5;
	/**
	 * 预览用户无法下单
	 */
	public static final int CodePreviewUserCannotOrder=6;
	/**
	 * 兑吧禁用
	 */
	public static final int CodeDuibaDisable=7;
	/**
	 * 商品下架
	 */
	public static final int CodeAppItemOffline=8;
	/**
	 * 档位不存在
	 */
	public static final int CodePriceDegreeNotExist=9;
	/**
	 * 没有权限
	 */
	public static final int CodeNoPermission=10;
	/**
	 * 今日兑换限制(今日已兑换,用户维度) 
	 */
	public static final int CodeTodayExchangeLimit=11;
	/**
	 * 商品兑换限制(已兑换,用户维度)
	 */
	public static final int CodeForeverExchangeLimit=12;
	/**
	 * 没有在兑换的时间区间内(限时兑换商品)
	 */
	public static final int CodeNotInLimitTime=13;
	/**
	 * 每日限量商品，当日没有库存(商品维度)
	 */
	public static final int CodeQuantityLimitNoStock=14;
	/**
	 * 会员等级限制，用户会员等级不符合兑换条件
	 */
	public static final int CodeVipLimit = 15;
	/**
	 * App是否繁忙
	 * 如果处理某个App的线程池排队超过100个，则认为该App繁忙
	 */
	public static final int CodeAppBusy=16;
	/**
	 * 兑吧临时禁止下单
	 * 一般用于不停机维护，确保在维护期间兑吧仍然是可访问的
	 */
	public static final int CodeDuibaTempDisableTakeOrder=17;
	
	/**
	 * 未登录用户无法下单。
	 */
	public static final int CodeNotLoginUserCannotOrder=18;
	
	/**
	 * 账户余额暂不可用
	 */
	public static final int CodeBalanceDisabled=19;
	/**
	 * APP交易数限制
	 */
	public static final int CodeAppTradingLimit=20;
	/**
	 * 商城用户并发下单限制
	 */
	public static final int CodeConsumerConcurrentTrade=21;
	/**
	 * 商城用户在3秒内频繁下单
	 */
	public static final int CodeFrequentExchange=22;
	/**
	 * IP兑换限制，一个ip一天内兑换不超过10次
	 */
	public static final int CodeIpExchangeLimit=23;
	
	/**
	 * form表单token不一致
	 */
	public static final int CodeFormTokenError=24;
	/**
	 * 同一设备切换用户3次限制兑换
	 */
	public static final int CodeAnticheat=25;
	/**
	 * 兑吧队列慢，系统繁忙
	 */
	public static final int CodeDuibaBusy=26;
	/**
	 * 防作弊策略判断拒绝
	 */
	public static final int CodeAnticheatStrategy=27;
	/**
	 * APP交易数限制下只能兑换测试专用券
	 */
	public static final int CodeAppTradingTestCouponLimit=28;
	
	/**
	 * 今日已兑完
	 */
	public static final int CodeTodayExchangeLimitSwitch=29;
	/**
	 * 地域限制内不可兑换
	 */
	public static final int CodeInAddrLimit=30;
	/**
	 * 兑吧定向商品，其它app无法兑换
	 */
	public static final int CodeSpecifyLimit=31;
	/**
	 * 兑吧黑名单商品，无法兑换
	 */
	public static final int CodeBlacklistLimit=32;
	
	/**
	 * 验证码防作弊
	 */
	public static final int CaptchaStrategy=33;
	/**
	 * 秒杀商品内存排队没排上
	 */
	public static final int CodeSecondKillQueueOut=34;
	
	private static final long serialVersionUID = 1L;

	private int code;
	//给用户看的原因
	private String text4consumer;
	//给管理员看的原因
	private String text4admin;
	
	public StatusException(int code,AppDO appDo){
		this.code=code;
		initDefaultText(appDo);
	}
	
	public StatusException(int code, String text4consumer,AppDO appDo) {
		this.code=code;
		initDefaultText(appDo);
		this.text4consumer=text4consumer;
	}

	public StatusException(int code){
		this.code=code;
		initDefaultText(null);
	}

	public StatusException(int code, String text4consumer) {
		this.code=code;
		initDefaultText(null);
		this.text4consumer=text4consumer;
	}

	private void initDefaultText(AppDO app) {
		if (code == CodeOtherException) {
			text4consumer = "网络异常，请稍后再试哦(0)";
		}
		if (code == CodeCreditsNotEnough) {
			String unitName = "积分";
			if (app != null) {
				unitName = app.getUnitName();
				if (app.isAppSwitch(AppDO.SwitchCreditsDecimalPoint)) {
					if("元".equals(unitName)){
						unitName = "金额";
					}
				}
			}
			text4consumer = unitName + "不足，多赚点再来哦";
		}
		if (code == CodeBalanceNotEnough) {
			text4consumer = "对不起，没有兑换成功，请挑选其他吧(2)";
		}
		if (code == CodeMonthBudgetNotEnough) {
			text4consumer = "对不起，没有兑换成功，请挑选其他吧(3)";
		}
		if (code == CodeDayBudgetNotEnough) {
			text4consumer = "对不起，没有兑换成功，请挑选其他吧(4)";
		}
		if (code == CodeStockNotEnough) {
			text4consumer = "哎呀，库存不足了，请挑选其他吧(5)";
		}
		if (code == CodePreviewUserCannotOrder) {
			text4consumer = "预览用户无法下单哦(6)";
		}
		if (code == CodeDuibaDisable) {
			text4consumer = "商品已下架，挑选其他吧(7)";
		}
		if (code == CodeAppItemOffline) {
			text4consumer = "商品已下架，挑选其他吧(8)";
		}
		if (code == CodePriceDegreeNotExist) {
			text4consumer = "商品已下架，挑选其他吧(9)";
		}
		if (code == CodeNoPermission) {
			text4consumer = "对不起，没有兑换成功，请挑选其他吧(10)";
		}
		if (code == CodeTodayExchangeLimit) {
			text4consumer = "今日已兑换，明天再来哦(11)";
		}
		if (code == CodeForeverExchangeLimit) {
			text4consumer = "该商品不能多次兑换，请挑选其他吧(12)";
		}
		if (code == CodeNotInLimitTime) {
			text4consumer = "请在限定时间内兑换哦(13)";
		}
		if (code == CodeQuantityLimitNoStock) {
			text4consumer = "今日已兑完，明天再来哦(14)";
		}
		if (code == CodeVipLimit) {
			text4consumer = "会员等级不符，请挑选其他吧(15)";
		}
		if (code == CodeAppBusy) {
			text4consumer = "对不起，系统繁忙了，请稍后再试哦(16)";
		}
		if (code == CodeDuibaTempDisableTakeOrder) {
			text4consumer = "对不起，系统维护中，请稍后再试哦(17)";
		}
		if (code == CodeNotLoginUserCannotOrder) {
			text4consumer = "请先登录哦，好礼等着你(18)";
		}
		if (code == CodeBalanceDisabled) {
			text4consumer = "正在补仓中，请稍后再试(19)";
		}
		if (code == CodeAppTradingLimit) {
			text4consumer = "对不起，系统繁忙了，请稍后再试哦(20)";
		}
		if (code == CodeConsumerConcurrentTrade) {
			text4consumer = "对不起，系统繁忙了，请稍后再试哦(21)";
		}
		if (code == CodeFrequentExchange) {
			text4consumer = "对不起，系统繁忙了，请稍后再试哦(22)";
		}
		if (code == CodeIpExchangeLimit) {
			text4consumer = "对不起，系统维护中，请稍后再试哦(23)";
		}
		if (code == CodeFormTokenError) {
			text4consumer = "对不起，没有兑换成功，请挑选其他吧(24)";
		}
		if (code == CodeAnticheat) {
			text4consumer = "对不起，没有兑换成功，请挑选其他吧(25)";
		}
		if (code == CodeDuibaBusy) {
			text4consumer = "对不起，系统繁忙了，请稍后再试哦(26)";
		}
		if (code == CodeAnticheatStrategy) {
			text4consumer = "对不起，没有兑换成功，请挑选其他吧(27)";
		}
		if (code == CodeAppTradingTestCouponLimit) {
			text4consumer = "测试期间仅限兑换测试专用券哦(28)";
		}
		if (code == CodeTodayExchangeLimitSwitch) {
			text4consumer = "今日已兑完，明天再来哦(29)";
		}
		if (code == CodeInAddrLimit) {
			text4consumer = "不在可兑换区域哦，请挑选其他吧(30)";
		}
		if (code == CodeSpecifyLimit) {
			text4consumer = "该商品已下架，请挑选其他吧(31)";
		}
		if (code == CodeBlacklistLimit) {
			text4consumer = "该商品已下架，请挑选其他吧(32)";
		}
		if (code == CaptchaStrategy) {
			text4consumer = "对不起，没有兑换成功，请挑选其他吧(33)";
		}
	}
	
	@Override
	public String getMessage() {
		return text4consumer;
	}

	public int getCode() {
		return code;
	}

	public String getText4consumer() {
		return text4consumer;
	}

	public String getText4admin() {
		return text4admin;
	}

}
