/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.domain.vo;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import java.io.Serializable;

public class ItemKey
implements Serializable {
    private final ItemDO item;
    private final AppItemDO appItem;
    private final AppDO app;

    public static ItemKey generate(ItemDO item, AppItemDO appItem, AppDO app) {
        return new ItemKey(item, appItem, app);
    }

    protected ItemKey(ItemDO item, AppItemDO appItem, AppDO app) {
        this.item = item;
        this.appItem = appItem;
        this.app = app;
    }

    public String getItemType() {
        if (this.getItem() != null) {
            return this.getItem().getType();
        }
        if (this.getAppItem() != null) {
            return this.getAppItem().getType();
        }
        return null;
    }

    public ItemDO getItem() {
        return this.item;
    }

    public AppItemDO getAppItem() {
        return this.appItem;
    }

    public boolean isValid() {
        return this.getItem() != null || this.getAppItem() != null;
    }

    public boolean isItemMode() {
        return this.item != null && this.appItem == null;
    }

    public boolean isSelfAppItemMode() {
        return this.item == null && this.appItem != null;
    }

    public boolean isDuibaAppItemMode() {
        return this.item != null && this.appItem != null;
    }

    public AppDO getApp() {
        return this.app;
    }

    public Boolean isAmbItemKey() {
        if (this.isDuibaAppItemMode()) {
            return false;
        }
        if (this.isSelfAppItemMode()) {
            return this.appItem.isOpTypeAppItem(11);
        }
        return this.item.isOpTypeItem(11);
    }
}

