package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

public class AppVipLimitDO extends BaseDO {
	private static final long serialVersionUID = 4601L;
	public static int HIDDEN_ITEM = 0;//隐藏不可兑换项
	public static int GUIDELINES = 1;//在兑换项中进行规则指引
	
	public static int USE_DUIBA = 0;//使用兑吧的规则页面
	public static int USE_YOUSELF = 1;//使用开发者自己的规则页面
	
	private Long id;
	private Long appId;
	private Integer doMethod;
	private Integer rulePoint;
	private String ruleUrl;
	private String ruleText;
	
	private Date gmtCreate;
	private Date gmtModified;
	
	public AppVipLimitDO() {
	}

	public AppVipLimitDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public AppVipLimitDO(Long id) {
		this.id = id;
		gmtModified = new Date();
		toBeUpdate = true;
	}
	
	public void beforeUpdate() {
		gmtModified = new Date();
	}
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getAppId() {
		return appId;
	}
	public void setAppId(Long appId) {
		this.appId = appId;
	}
	public Integer getDoMethod() {
		return doMethod;
	}
	public void setDoMethod(Integer doMethod) {
		this.doMethod = doMethod;
	}
	public Integer getRulePoint() {
		return rulePoint;
	}
	public void setRulePoint(Integer rulePoint) {
		this.rulePoint = rulePoint;
	}
	public String getRuleUrl() {
		return ruleUrl;
	}
	public void setRuleUrl(String ruleUrl) {
		this.ruleUrl = ruleUrl;
	}
	public String getRuleText() {
		return ruleText;
	}
	public void setRuleText(String ruleText) {
		this.ruleText = ruleText;
	}
	public Date getGmtCreate() {
		return gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}
	public Date getGmtModified() {
		return gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}
}
