package cn.com.duiba.service.remoteservice;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.service.domain.dataobject.OrdersFasterDO;
import cn.com.duiba.service.domain.vo.DevAbnormalOrderVO;
import cn.com.duiba.service.domain.vo.OrderFasterVO;

public interface RemoteOrdersFasterBizReadService {

	public Integer getProcessingOrdersCount(Long appId, Date startDay, Date endDay) ;
	
	public Integer getAuditOrdersCount(Long appId) ;
	
	public Integer getVirtualAbnormalOrdersCount(Long appId,Date delayTime);
	
	public Long getWaitOrdersCount(Long appId) ;
	
	public Map<String, Long> getTimeOutRowAndMax(Date endTime, String orderNum, String type);
	
	public List<Long> findTimeOutExportOrderIds(Date endTime, String orderNum, String type, Long maxId, Integer offset, Integer max);
	
	public List<Long> findWaitExportOrderIds(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date startDate, Date endDate, Long maxId, Integer offset, Integer max);
	
	public Map<String, Long> getWaitRowAndMax(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date startDate, Date endDate, Long maxId, Integer offset, Integer max);
	
	public List<DevAbnormalOrderVO> findVirtualAbnormalOrder(Long appId, String orderNum, String supplierBizId, Long consumerId, Date timeout, Integer offset, Integer max);
	
	public Long findVirtualAbnormalOrderCount(Long appId, String orderNum, String supplierBizId, Long consumerId, Date timeout);

	public List<OrderFasterVO> findDevWaitOrderFast(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date startDate, Date endDate, Integer start, Integer pageSize);
	
	public Long findDevWaitOrderFastCount(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date startDate, Date endDate) ;
	
	public List<OrderFasterVO> findDevWaitOrderFastByOrderNum(Long appId, String orderNum);
	
	public List<OrdersFasterDO> findSencodeKillOrder(String orderNum, String type, Integer start, Integer pageSize);
	
	public Long findSencodeKillOrderCount(String orderNum, String type);
	
	public List<OrdersFasterDO> findTimeoutOrder(Date endTime, String orderNum, String type, Long maxId, Integer offset, Integer max);
	
	public Long findTimeoutOrderCount(Date endTime, String orderNum, String type);
	
	public List<OrdersFasterDO> findLotteryTimeoutOrder(Date timeoutTime, String orderNum, String type, Long maxId, Date startTime, Date endTime, Integer offset, Integer max);
	
	public Long findLotteryTimeoutOrderCount(Date timeoutTime, String orderNum, String type, Long maxId, Date startTime, Date endTime);
	
	public List<OrdersFasterDO> findHdToolTimeoutOrder(Date timeoutTime, String orderNum, String type, Long maxId, Date startTime, Date endTime, Integer offset, Integer max);
	
	public Long findHdToolTimeoutOrderCount(Date timeoutTime, String orderNum, String type, Long maxId, Date startTime, Date endTime);
	
	public List<OrderFasterVO> findOrderFastShippNew(String exchangeStatus, String orderId, String objectName, String remarks, String haveRemarks, String orderSource, Integer offset, Integer max);
	
	public Long findOrderFastShippNewCount(String exchangeStatus, String orderId, String objectName, String remarks, String haveRemarks, String orderSource);
	
	public List<OrderFasterVO> findAuditOrderFast(Map<String,Object> paramMap);
	
	public Long findAuditOrderFastCount(Map<String,Object> paramMap);
	
	public List<Long> findExportShippDuibaOrders(String exchangeStatus, String orderId, String objectName, String remarks, String haveRemarks, String orderSource,Long maxId, Integer offset, Integer max);
	
	public Long getShippDuibaMax(String exchangeStatus, String orderId, String objectName, String remarks, String haveRemarks, String orderSource) ;
	
	public Long getShippDuibaCount(String exchangeStatus, String orderId, String objectName, String remarks, String haveRemarks, String orderSource,Long maxId);
}
