package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.domain.dataobject.CouponBatchDO;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.domain.vo.CouponImportResult;

import java.util.Date;
import java.util.List;

/**
 * 优惠券service
 */
public interface RemoteCouponFlowService {

	/**
	 * <b>取一张优惠券</b> <br/>
	 *
	 * 1:验证商品库存<br/>
	 * 2:验证商品对应批次是否可用<br/>
	 * 3:获取一张未锁定未使用的优惠券<br/>
	 * 4.更新批次库存<br/>
	 * 5.更新兑换项库存<br/>
	 * 如果该批次已经用完，执行下面流程 6.刷新批次信息<br/>
	 * 7.切换批次<br/>
	 * 8.更新兑换项批次引用<br/>
	 *
	 * @param itemKey
	 * @return couponId
	 * @throws Exception
	 */
	public CouponDO getOneCoupon(ItemKey itemKey) throws StatusException;

	/**
	 * <b>返还一张优惠券</b> <br/>
	 *
	 * 1.验证优惠券锁定状态是否为true<br/>
	 * 2.设置优惠锁定状态为 false<br/>
	 * 3.更新批次库存<br/>
	 * 4.更新兑换项库存<br/>
	 * 如果该批次是未过期，且状态为已使用，执行下面流程 5.刷新批次信息<br/>
	 * 6.切换批次<br/>
	 * 7.更新兑换项批次引用<br/>
	 *
	 * @throws Exception
	 */
	public void returnOneCoupon(long couponId) throws StatusException;

	/**
	 * <b>导入开发者普通券码</b><br/>
	 * 1.根据批次时间，判断新增批次或现有批次追加库存<br/>
	 * 2.批量insert 到优惠券<br/>
	 * 3.更新批次库存<br/>
	 * 4.更新兑换项库存<br/>
	 * 5.刷新批次信息<br/>
	 * 6.切换批次<br/>
	 * 7.更新兑换项批次引用<br/>
	 * 8.更新兑换项最大过期时间<br/>
	 */
	public int importAppItemCouponNormal(long appItemId, Long batchId, Date startTime, Date endTime, List<CouponDO> coupons) throws BusinessException,StatusException;

	/**
	 * <b>删除优惠券批次</b> <br/>
	 * 1.开启事务 <br/>
	 * 2.删除批次 <br/>
	 * 3.删除批次优惠券 <br/>
	 * 4.更新批次库存<br/>
	 * 5.更新兑换项库存<br/>
	 * 6.刷新批次信息<br/>
	 * 7.切换批次<br/>
	 * 8.更新兑换项批次引用<br/>
	 * 9.更新兑换项最大过期时间<br/>
	 * 10.提交事务
	 *
	 * @param itemKey
	 * @return
	 * @throws Exception
	 */
	public void deleteCouponBatch(long batchId) ;

	/**
	 * <b>删除优惠券券码</b> <br/>
	 * 1.开启事务 <br/>
	 * 2.删除优惠券券码 （未锁定，未领取）<br/>
	 * 3.更新批次库存<br/>
	 * 4.更新兑换项库存<br/>
	 * 5.刷新批次信息<br/>
	 * 6.切换批次<br/>
	 * 7.更新兑换项批次引用<br/>
	 * 8.更新兑换项最大过期时间<br/>
	 * 9.提交事务<br/>
	 *
	 * @param itemKey
	 * @return
	 * @throws Exception
	 */
	public int deleteCouponCode(long couponId) throws StatusException;

	/**
	 * <b>扫描过期优惠券</b> <br/>
	 * 1.扫描自有优惠券<br/>
	 * 2.扫描兑吧优惠券<br/>
	 */
	public int scanOverdueCoupon();

	/**
	 * <b>刷新自有商品优惠券信息 </b><br/>
	 *
	 * 1.更新兑换项库存 <br/>
	 * 2.更新兑换项过期时间 <br/>
	 *
	 * @param itemKey
	 * @throws Exception
	 */
	public void refreshAppItemCoupon(long appItemId);

	/**
	 * <b>刷新批次信息 </b><br/>
	 * 1.判断是否过期<br/>
	 * 2.统计批次优惠券可用库存<br/>
	 * 3.如果批次有可用库存且批次为已使用，修改为新建<br/>
	 * 4.如果没库存修改为已使用
	 */
	public void refreshBatch(CouponBatchDO couponBatchDO);

	/**
	 * <b>自有商品切换批次 </b><br/>
	 *
	 * 0.开启事务<br/>
	 * 1.判断当前批次无效<br/>
	 * 2.批次过期置为失效 CouponBatchDO.ActiveOverdue <br/>
	 * 3.批次已使用且count优惠券有库存设置为新建 CouponBatchDO.ActiveNew <br/>
	 * 4.批次使用中且count优惠券无库存设置为已使用 <br/>
	 * 5.查询下一个批次 <br/>
	 * 6.根据下一个批次ID统计优惠券库存 <br/>
	 * 7.设置下一个批次为使用中CouponBatchDO.ActiveUsing <br/>
	 * 9.修改兑换项批次引用ID <br/>
	 * 10.提交事务
	 *
	 * @throws Exception
	 */
	public void switchAppItemBatch(long appItemId);

	/**
	 * <b>导入开发者链接券码</b><br/>
	 * 1.根据批次时间，判断新增批次或现有批次追加库存<br/>
	 * 2.批量insert 到优惠券<br/>
	 * 3.更新批次库存<br/>
	 * 4.更新兑换项库存<br/>
	 * 5.刷新批次信息<br/>
	 * 6.切换批次<br/>
	 * 7.更新兑换项批次引用<br/>
	 * 8.更新兑换项最大过期时间<br/>
	 */
	public int importAppItemCouponLink(long appItemId, Long batchId, Date startTime, Date endTime, String link, String showText, int instock, int maxLine) throws BusinessException,StatusException;

	/**
	 * <b>导入开发者可重复券码 </b><br/>
	 * 1.根据批次时间，判断新增批次或现有批次追加库存<br/>
	 * 2.批量insert 到优惠券<br/>
	 * 3.更新批次库存<br/>
	 * 4.更新兑换项库存<br/>
	 * 5.刷新批次信息<br/>
	 * 6.切换批次<br/>
	 * 7.更新兑换项批次引用<br/>
	 * 8.更新兑换项最大过期时间<br/>
	 */
	public int importAppItemCouponRepeat(long appItemId, Long batchId, Date startTime, Date endTime, String code, String password, int instock,int maxLine) throws BusinessException,StatusException;

	/**
	 * <b>导入兑吧可重复券码 </b><br/>
	 * 1.根据批次时间，判断新增批次或现有批次追加库存<br/>
	 * 2.批量insert 到优惠券<br/>
	 * 3.更新批次库存<br/>
	 * 4.更新兑换项库存<br/>
	 * 5.刷新批次信息<br/>
	 * 6.切换批次<br/>
	 * 7.更新兑换项批次引用<br/>
	 * 8.更新兑换项最大过期时间<br/>
	 */
	public int importItemCouponRepeat(long itemId, Long batchId, Date startTime, Date endTime, String code, String password, int instock) throws BusinessException,StatusException;

	/**
	 * <b>导入兑吧链接券码</b><br/>
	 * 1.根据批次时间，判断新增批次或现有批次追加库存<br/>
	 * 2.批量insert 到优惠券<br/>
	 * 3.更新批次库存<br/>
	 * 4.更新兑换项库存<br/>
	 * 5.刷新批次信息<br/>
	 * 6.切换批次<br/>
	 * 7.更新兑换项批次引用<br/>
	 * 8.更新兑换项最大过期时间<br/>
	 */
	public int importItemCouponLink(long itemId, Long batchId, Date startTime, Date endTime, String link, String showText, int instock) throws BusinessException,StatusException;

	/**
	 * <b>刷新兑吧商品优惠券信息 </b><br/>
	 *
	 * 1.更新兑换项库存 <br/>
	 * 2.更新兑换项过期时间 <br/>
	 *
	 * @param itemKey
	 * @throws Exception
	 */
	public void refreshItemCoupon(long itemId);

	/**
	 * <b>兑吧商品切换批次 </b><br/>
	 *
	 * 0.开启事务<br/>
	 * 1.判断当前批次无效<br/>
	 * 2.批次过期置为失效 CouponBatchDO.ActiveOverdue <br/>
	 * 3.批次已使用且count优惠券有库存设置为新建 CouponBatchDO.ActiveNew <br/>
	 * 4.批次使用中且count优惠券无库存设置为已使用 <br/>
	 * 5.查询下一个批次 <br/>
	 * 6.根据下一个批次ID统计优惠券库存 <br/>
	 * 7.设置下一个批次为使用中CouponBatchDO.ActiveUsing <br/>
	 * 9.修改兑换项批次引用ID <br/>
	 * 10.提交事务
	 *
	 * @param itemKey
	 * @throws Exception
	 */
	public void switchItemBatch(long itemId);

	/**
	 * <b>导入兑吧普通券码</b><br/>
	 * 1.根据批次时间，判断新增批次或现有批次追加库存<br/>
	 * 2.批量insert 到优惠券<br/>
	 * 3.更新批次库存<br/>
	 * 4.更新兑换项库存<br/>
	 * 5.刷新批次信息<br/>
	 * 6.切换批次<br/>
	 * 7.更新兑换项批次引用<br/>
	 * 8.更新兑换项最大过期时间<br/>
	 */
	public CouponImportResult importItemCouponNormal(long itemId, Long batchId, Date startTime, Date endTime, String fileUrl, String fileType) throws BusinessException,StatusException;

	/**
	 * <b>取商品当前批次</b><br/>
	 * 1.如果是兑吧商品返回兑吧商品引用批次<br/>
	 * 2.如果是自有山炮返回自有商品应用批次<br/>
	 *
	 * @param itemKey
	 * @return
	 * @throws Exception
	 */
	public CouponBatchDO getItemKeyCurrentCouponBatch(ItemKey itemKey) throws StatusException;
}
