package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.dataobject.PreStockDO;
import cn.com.duiba.service.domain.dataobject.PreStockPointDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.exception.StatusException;

import java.util.List;

public interface RemotePreStockService {

	public PreStockDO findByPointId(Long pointId);
	
	public PreStockDO newStock(PreStockDO stock);
	
	public boolean addQuantity(Long stockId, long quantity);
	
	public boolean reduceQuantity(Long stockId, long quantity);
	
	public List<PreStockDO> findAllByPointIds(List<Long> pointIds);


	//from PreStockConsumeServiceImpl

	public void consumeStock(String bizId,Long appId, Long pointId) throws BusinessException,StatusException;

	public void paybackStock(String bizId) throws BusinessException;

	/**
	 * 查询库存预分配最小兑换价格
	 * 若分配，则取分配的，若为null,则取兑换项本身的
	 */
	public Integer getMinExchangePrice(ItemDO item, AppDO app);

	/**
	 * 查询库存预分配的库存
	 * 为null则最兑换项本身的
	 */
	public Long getPreStock(ItemDO item, AppDO app);

	public Integer getPreStockQuantitySales(ItemKey itemKey);

	/**
	 * 判断chargeMode 是否需要限时限量计数
	 * @return
	 */
	public boolean chargeMode(String chargeMode);


	/**
	 * 判断是否是兑吧库存预分配
	 * @return
	 */
	public PreStockPointDO getPointStock(ItemDO item, AppDO app);

	/**
	 * 计算消耗积分数 如果是有档次的兑换商品，传入degree，如果没有传入degreee，返回最小档次的积分
	 *
	 * @param key
	 * @param degree
	 * @return
	 */
	public Long calculateCreditsByItemKeyAndDegree(ItemKey key,String degree);

	/**
	 * 计算消耗积分数 如果是有档次的兑换商品，传入degree，如果没有传入degreee，返回最小档次的积分
	 *
	 * @param key
	 * @param degree
	 * @return
	 */
	public Long calculateCreditsByItemKeyAndDegree_manager(ItemKey key,String degree);

	//from PreStockOperateServiceImpl

	/**
	 * 新建一个库存
	 * @param relationType
	 * @param relationId
	 * @return
	 */
	public long newStock(Long pointId,Long stock) throws BusinessException;
	/**
	 * 添加库存
	 * @param relationType
	 * @param relationId
	 * @param stock
	 * @return
	 */
	public boolean addStockQuantity(Long bizId,Long pointId,Integer quantity) throws BusinessException;
	/**
	 * 减少库存
	 * @param relationType
	 * @param relationId
	 * @param stock
	 * @return
	 */
	public boolean reduceStockQuantity(Long bizId,Long pointId,Integer quantity) throws BusinessException;

	/**
	 * 减去所有
	 * @param bizId
	 * @param pointId
	 * @return
	 * @throws Exception
	 */
	public boolean reduceStockAll(Long bizId,Long pointId) throws BusinessException;

	/**
	 * from ItemCtrl.submitPreStock in manager
	 * @param insertPointList
	 * @param updatePointList
	 * @throws BusinessException
	 */
	public void submitPreStock(List<PreStockPointDO> insertPointList, List<PreStockPointDO> updatePointList) throws BusinessException;


	//from StockService in credits

	public Integer getRemaining(ItemKey itemKey);

	/**
	 * 查询库存，不包含定向
	 */
	public Integer getRemainingNoSpecify(ItemKey itemKey);

	/**
	 * 查询库存
	 * @param itemKey
	 * @return
	 */
	public Integer findRemaining(ItemKey itemKey);

	/**
	 * 返还库存
	 */
	public void increaseRemaining(ItemKey key, Long couponId);

	public void increaseRemainingNoTransaction(ItemKey key, Long couponId) throws StatusException;
}
