package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;
import org.apache.commons.lang.StringUtils;

import java.util.Date;

public class AppLayoutBrickDO extends BaseDO{
	//系统模版所属的位置
	public final static int POSITION_THEME = 0;
	public final static int POSITION_TOP = 1;
	public final static int POSITION_BANNER = 2;
	public final static int POSITION_ICON = 3;
	public final static int POSITION_ITEM = 4;
	
	public final static int STATUS_HIDDEN = 0;
	public final static int STATUS_SHOW = 1;
	@Deprecated
	public final static int STATUS_PUBLISH=100;//正在被线上使用
	@Deprecated
	public final static int STATUS_DRAFT=101;//还在被草稿引用
	
	public final static int IMAGE_STYLE_DEFAUL = 0;
	public final static int IMAGE_STYLE_WHITE = 1;
	
	private Long id;
	private Long appId;
	private String name;
	private String content;
	private String md5;
	private Integer payload;
	private Integer position;
	private String image;
	private Integer deleted;//形式上被删除时置为1,未删除为0
	private Integer status;//显示为1，隐藏为0
	private Integer imageStyle;
	
	private Date gmtCreate;
	private Date gmtModified;
	//用于VO的显示,不进行数据库保存
	private transient Long appCount;
	private transient Boolean isNew;
	
	public AppLayoutBrickDO(){}
	
	public AppLayoutBrickDO(boolean init4insert){
		if (init4insert) {
			toBeInsert = true;
			
			status = STATUS_HIDDEN;//新添加的模块为隐藏
			deleted = 0;
			payload=0;
			
			gmtCreate = new Date();
			gmtModified = new Date();
		}		
	}
	
	public AppLayoutBrickDO(Long id){
		toBeUpdate = true;
		this.id = id;
		
		gmtModified = new Date();
	}
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getAppId() {
		return appId;
	}
	public void setAppId(Long appId) {
		this.appId = appId;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getContent() {
		return content;
	}
	public void setContent(String content) {
		this.content = content;
	}
	public String getMd5() {
		return md5;
	}
	public void setMd5(String md5) {
		this.md5 = md5;
	}
	public Integer getPayload() {
		return payload;
	}
	public void setPayload(Integer payload) {
		this.payload = payload;
	}
	public Integer getPosition() {
		return position;
	}
	public void setPosition(Integer position) {
		this.position = position;
	}
	public String getImage() {
		return image;
	}
	public void setImage(String image) {
		this.image = image;
	}
	public Integer getDeleted() {
		return deleted;
	}
	public void setDeleted(Integer deleted) {
		this.deleted = deleted;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getAppCount() {
		return appCount;
	}

	public void setAppCount(Long appCount) {
		this.appCount = appCount;
	}
	
	public void updateValidate() throws Exception{//只做内容校验
		if(StringUtils.isBlank(name)){
			throw new Exception("皮肤名称不能为空");
		}
		if(StringUtils.isBlank(image)){
			throw new Exception("皮肤展示图不能为空");
		}
		if(StringUtils.isBlank(content)){
			throw new Exception("皮肤内容不能为空");
		}
		if(payload<=0){
			throw new Exception("权重必须大于0");
		}
	}

	public Boolean getIsNew() {
		return isNew;
	}

	public void setIsNew(Boolean isNew) {
		this.isNew = isNew;
	}

	public Integer getImageStyle() {
		return imageStyle;
	}

	public void setImageStyle(Integer imageStyle) {
		this.imageStyle = imageStyle;
	}
}
