package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.Date;

public class AppLayoutDO extends BaseDO {
	private Long id;
	private Long appId;
	/**
	 * 线上使用的brickIds
	 */
	private String brickIds;
	/**
	 * 草稿中记录的brickIds
	 */
	@Deprecated
	private String draftBrickIds;
	/**
	 * 5个位置的模块，自定义的brickIds 这些brickIds有可能只是记着，但没有在线上使用，或者没有在草稿被选中
	 */
	@Deprecated
	private String customBrickIds;

	private String themeColor;
	@Deprecated
	private String draftThemeColor;

	private Date gmtCreate;
	private Date gmtModified;
	

	public AppLayoutDO() {
	}

	public AppLayoutDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;

			gmtCreate = new Date();
			gmtModified = new Date();
		}

	}
	
	public Long getThemeId(){
		if(StringUtils.isBlank(brickIds)){
			return null;
		}
		JSONObject json = JSONObject.parseObject(brickIds);
		return json.getLong("0")==null?1L:json.getLong("0");
		
	}

	public AppLayoutDO(Long id) {
		toBeUpdate = true;
		this.id = id;
		gmtModified = new Date();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public String getBrickIds() {
		return brickIds;
	}

	public void setBrickIds(String brickIds) {
		this.brickIds = brickIds;
	}

	public String getDraftBrickIds() {
		return draftBrickIds;
	}

	public void setDraftBrickIds(String draftBrickIds) {
		this.draftBrickIds = draftBrickIds;
	}

	public String getCustomBrickIds() {
		return customBrickIds;
	}

	public void setCustomBrickIds(String customBrickIds) {
		this.customBrickIds = customBrickIds;
	}

	public String getThemeColor() {
		return themeColor;
	}

	public void setThemeColor(String themeColor) {
		this.themeColor = themeColor;
	}

	public String getDraftThemeColor() {
		return draftThemeColor;
	}

	public void setDraftThemeColor(String draftThemeColor) {
		this.draftThemeColor = draftThemeColor;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

}
