package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

public class CouponDO extends BaseDO {
	private Long id;
	private Integer version;
	private Long itemId;
	private Long appItemId;
	private String code; // 兑换码
	private String password;
	private Boolean used;// 是否已经使用了
	private Boolean locked; // 加锁，在兑换时通过这个，防止并发异常
	private Long batchId; // 优惠券批次号
	private Long orderId; //订单Id
	private Date gmtCreate;
	private Date gmtModified;
	
	public CouponDO() {
	}

	public CouponDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public CouponDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			used = false;
			locked = false;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public Boolean getUsed() {
		return used;
	}

	public void setUsed(Boolean used) {
		this.used = used;
	}

	public Boolean getLocked() {
		return locked;
	}

	public void setLocked(Boolean locked) {
		this.locked = locked;
	}

	public Long getBatchId() {
		return batchId;
	}

	public void setBatchId(Long batchId) {
		this.batchId = batchId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	public Long getOrderId() {
	    return orderId;
    }
	public void setOrderId(Long orderId) {
	    this.orderId = orderId;
    }
}
