package cn.com.duiba.service.domain.vo;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;

import java.io.Serializable;

public class ItemKey implements Serializable{

	private final ItemDO item;
	private final AppItemDO appItem;
	private final AppDO app;
	/**
	 * 开发者不得调用此方法！！！
	 * 此方法只提供给ItemKeyService调用！！
	 * @param item
	 * @param appItem
	 * @param app
	 * @return
	 */
	public static ItemKey generate(ItemDO item, AppItemDO appItem, AppDO app){
		return new ItemKey(item, appItem, app);
	}
	
	protected ItemKey(ItemDO item, AppItemDO appItem, AppDO app){
		this.item=item;
		this.appItem=appItem;
		this.app=app;
	}
	/**
	 * 获取商品类型
	 * @return
	 */
	public String getItemType(){
		if(getItem()!=null){
			return getItem().getType();
		}
		if(getAppItem()!=null){
			return getAppItem().getType();
		}
		return null;
	}
	

	public ItemDO getItem() {
		return item;
	}

	public AppItemDO getAppItem() {
		return appItem;
	}
	/**
	 * 是否有效
	 * (某些情况下，商品被删除，导致无法加载出来，这个时候认为ItemKey无效)
	 * @return
	 */
	public boolean isValid(){
		return (getItem()!=null || getAppItem()!=null);
	}
	/**
	 * 是否Item模式
	 * @return
	 */
	public boolean isItemMode(){
		return item!=null && appItem==null;
	}
	/**
	 * 是否自有AppItem模式
	 * @return
	 */
	public boolean isSelfAppItemMode(){
		return item==null && appItem!=null;
	}
	/**
	 * 是否兑吧AppItem模式
	 * @return
	 */
	public boolean isDuibaAppItemMode(){
		return item!=null && appItem!=null;
	}

	public AppDO getApp() {
		return app;
	}
	
	public Boolean isAmbItemKey(){
	    if(this.isDuibaAppItemMode()){
	    	//加钱购不支持兑吧商品
	    	return false;
	    }else if(this.isSelfAppItemMode()) {
            return appItem.isOpTypeAppItem(ItemDO.OpTypeIsAmb);
        }else {
        	return item.isOpTypeItem(ItemDO.OpTypeIsAmb);
        }
	}
	
}
