package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.domain.dataobject.CouponBatchDO;

import java.util.Date;
import java.util.List;

/**
 * Created by wenqi.huang on 16/5/4.
 */
public interface RemoteCouponBatchService {

    public void insert(CouponBatchDO couponBatchDO);

    public int update(CouponBatchDO couponBatchDO);

    public CouponBatchDO find(Long id);

    public CouponBatchDO findForUpdate(Long id);

    /**
     * 查询商品下一个可用批次
     */
    public CouponBatchDO findItemNextBatch(Long itemId);

    public CouponBatchDO findAppItemNextBatch(Long appItemId);

    /**
     * 查询商品最大过期时间批次
     */
    public CouponBatchDO findItemMaxValidEndDateBatch(Long itemId);

    public CouponBatchDO findAppItemMaxValidEndDateBatch(Long appItemId);

    /**
     * 修改批次状态和库存
     */
    public int updateActiveAndRemaining(Long id, Integer active, Integer remaining);

    public int updateActive(Long id, Integer active);

    /**
     * 根据批次时间查询批次
     */
    public CouponBatchDO findItemBatchByValidStartDateAndValidEndDate(Long itemId, Date validStartDate, Date validEndDate);

    public CouponBatchDO findAppItemBatchByValidStartDateAndValidEndDate(Long appItemId, Date validStartDate, Date validEndDate);

    /**
     * 根据itemId获取最后一个批次
     */
    public CouponBatchDO findLastBatchByItemId(Long itemId);

    /**
     * 查询兑换项-优惠券的所有批次
     *
     * @param appItemId
     * @param itemId
     * @param valid
     *            NULL-所有批次 不包含删除的批次 "valid"--正在使用和新建的批次
     * @return
     */
    public List<CouponBatchDO> findAllBatch(Long appItemId, Long itemId, String valid);

    /**
     * 刷新所有新建但过期了的批次
     *
     * @return
     */
    public void updateAllNewOverDueBatch();

    /**
     * 将批次设为NULL
     *
     * @param itemId
     */
    public void setItemBatchEmpty(Long itemId);

    public void setAppItemBatchEmpty(Long appItemId);

    /**
     * 根据优惠券ID和结束时间查找批次
     *
     * @param appItemId
     * @param itemId
     * @param validEndDate
     * @return
     */
    public CouponBatchDO findBatchByValidEndDate(Long appItemId, Long itemId, Date validEndDate);

    public CouponBatchDO findBatchByValidStartDateAndValidEndDate(Long appItemId, Long itemId, Date validStartDate, Date validEndDate);

    /**
     * 查询最大结束时间
     *
     * @param appItemId
     * @param itemId
     * @return
     */
    public Date getMaxValidEndDate(Long appItemId, Long itemId);

    /**
     * 查询最近有效的结束时间
     *
     * @param appItemId
     * @param itemId
     * @return
     */
    public Date getMinValidEndDate(Long appItemId, Long itemId);

    /**
     * 计算优惠券有效库存
     *
     * @param appItemId
     * @param itemId
     * @return
     */
    public Integer countAllRemaining(Long appItemId, Long itemId);

    /**
     * 删除批次信息
     *
     * @param batchId
     * @return
     */
    public Integer deleteBatchRecord(Long batchId);

    /**
     * 返还批次库存+1
     *
     * @param batchId
     * @return
     */
    public Integer turnbackCouponBatchRemaining(Long batchId);

    /**
     * 扣除批次库存-1
     *
     * @param batchId
     * @return
     */
    public Integer reduceCouponBatchRemaining(Long batchId);

    /**
     * 计算批次剩余库存
     *
     * @param batchId
     * @return
     */
    public Integer countBatchRemaining(Long batchId);

    /**
     * @AUTH: ZhangPan
     * @Date: 2015年1月5日 下午7:41:50
     * @Description:根据批次Id列表查询各批次
     */
    public List<CouponBatchDO> findBatchInIds(List<Long> ids);
}
