package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.domain.dataobject.ItemStockConsumeDO;

import java.util.Date;

/**
 * Created by wenqi.huang on 16/5/4.
 */
public interface RemoteItemStockConsumeService {
    public int insert(ItemStockConsumeDO itemStockConsumeDO);

    public int countConsumeStockLock(Long relationId, String relationType, Date time);

    public int countAppConsumeStockLock(Long relationId, String relationType, Long appId, Date time);

    public ItemStockConsumeDO findByBizIdAndSource(String bizId, String bizSource);

    /**
     * 消费普通商品库存
     * 只针对实物，虚拟商品
     * @param itemKey
     * @param bizId
     * @param bizSource
     * @throws Exception
     */
    public void consumeStock(ItemKey itemKey, String bizId, String bizSource) throws BusinessException;

    /**
     * 普通商品返库存
     * 只针对实物，虚拟商品
     * @param bizId
     * @param bizSource
     * @throws Exception
     */
    public void paybackStock(String bizId,String bizSource) throws BusinessException;
}
