package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppLayoutDO;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;

/**
 * Created by wenqi.huang on 16/5/9.
 */
public interface RemoteAppLayoutService {
    /**
     * 新建布局
     * @param appLayout
     * @author 刘瑶
     */
    public int insert(AppLayoutDO appLayout);
    /**
     * 根据AppId找出对应的布局
     * @param appId
     * @author 刘瑶
     */
    public AppLayoutDO findByAppId(Long appId);
    /**
     * 更改主题配置
     * @param of
     * @param brickId
     */
    public int updateTheme(Optional<Long> id, Optional<JSONObject> brickIdJson);
    /**
     * 更改主题色
     * @param of
     * @param color
     * @return
     */
    public int updateColor(Optional<Long> id, Optional<String> color);
    /**
     * 历史原因，以前的手机端都引用APP中的主题的，所以在更新appLayout中的主题色时，APP中的也同步修改
     * 不过在后续的开发中，应该尽可能的使用appLayout中的themeColor
     * @param app
     * @param color
     */
    public int updateAppColor(Optional<AppDO> app, Optional<String> color);
}
