package cn.com.duiba.service.item.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;
import cn.com.duiba.service.domain.dataobject.AppBannerDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import com.google.common.collect.ImmutableSet;

import java.util.Date;

public class OperatingActivityDO extends BaseDO {

	private static final long serialVersionUID = -1632757211115283672L;

	public static final int TypeDuibaActivity = 0; //专题活动
	public static final int TypeTurnTable = 1; // 大转盘活动
	public static final int TypeDuibaSingleLottery = 2; // 兑吧单品抽奖
	public static final int TypeAppSingleLottery = 3; // App自有单品抽奖
	public static final int TypeDuibaTurntable = 4; //兑吧大转盘
	public static final int TypeAppManualLottery = 5; //app自有手动开奖
	public static final int TypeShakeLottery = 6;//摇一摇
	public static final int TypeScratchCard = 7;//刮刮卡
	public static final int TypeHdToolTurntable = 8;//活动工具大转盘
	public static final int TypeHdToolTiger = 9;//老虎机
	public static final int TypeSecondsKill = 30;//周三必抢
	
	public static final int TypeGameSanta = 20;//游戏活动-打劫圣诞老人
	public static final int TypeGameYearAward = 21;//游戏活动-数年终奖
	public static final int TypeGameGirl = 22;//游戏活动-女神pk
	//增加游戏的时候，请把新增的游戏类型加到下面的ImmutableSet《《《《《——————————注意
	public static final ImmutableSet<Integer> GAME_TYPES = ImmutableSet.of(TypeGameSanta,TypeGameYearAward,TypeGameGirl);
	
	public static final int TypeDuibaQuestionAnswer = 40;	// 兑吧答题
	public static final int TypeDuibaQuizz = 41;	// 测试题
	public static final int TypeDuibaSeckill = 31;	// 兑吧秒杀活动
	
	//从此判断活动工具变得很容易！！
	public static final ImmutableSet<Integer> hdToolTypeSet = ImmutableSet.of(TypeShakeLottery,TypeScratchCard,TypeHdToolTurntable,TypeHdToolTiger);

	public static final int StatusIntNoComplete = 0; //数据不完整
	public static final int StatusIntComplete = 1; //数据完整
	public static final int StatusIntOpen = 2; //开启
	public static final int StatusIntClose = 3; //关闭

	private Long id;
	private Long appId; //appId
	private String title; //标题
	private Integer type; //活动类型 
	private Integer status; //数据状态  引用：StatusInt*
	private Long appBannerId; //首页bannerID
	private Long appItemId; //兑换项ID
	private Long consumeCredits; // 消耗的总积分数
	private Integer consumeMoney;// 消耗的总金钱数
	private Integer visitTimes; // 参与人数
	private Integer winTimes; // 中奖人数
	private Long credits; // 消耗积分数
	private Integer limitCount; // 每日最多几次
	private Integer freeLimit; // 每日免费次数
	private String rule;// 活动规则
	private String explainText; // 活动说明
	
	private String image; // 主图
	private String smallImage;//缩略图
	private String logo;//小图标
	private String bannerImage;//banner
	
	private Long activityId; //引用活动ID,  如：兑吧专题活动，兑吧单品抽奖，兑吧大转盘.....
	private Integer activityOrderQuantity; //活动订单数

	private Integer failCount; // 领取失败数量， 数据库无此字段

	private Long parentActivityId;
	
	private Boolean deleted; // 是否已经删除
	private Date gmtCreate; //创建时间
	private Date gmtModified; //变更时间
	
	private Integer creditsType;//积分模式
	private String subType;//活动模版
	private String freeScope;//免费参数次数限制类型
	private String limitScope;//参与次数限制类型
	
	private String rateIntroduction;	// 概率说明
	
	public OperatingActivityDO(){}

	public OperatingActivityDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			consumeCredits = 0L;
			consumeMoney = 0;
			visitTimes = 0;
			winTimes = 0;
			credits = 0L;
			limitCount = 0;

			activityOrderQuantity = 0;
			deleted = false;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
			
		}
	}
	
	public OperatingActivityDO(Long id) {
		this.id = id;
		this.gmtModified=new Date();
		toBeUpdate = true;
	}
	
	public String getRateIntroduction() {
		return rateIntroduction;
	}

	public void setRateIntroduction(String rateIntroduction) {
		this.rateIntroduction = rateIntroduction;
	}

	public Long getParentActivityId() {
		return parentActivityId;
	}

	public void setParentActivityId(Long parentActivityId) {
		this.parentActivityId = parentActivityId;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Long getAppBannerId() {
		return appBannerId;
	}

	public void setAppBannerId(Long appBannerId) {
		this.appBannerId = appBannerId;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public Long getConsumeCredits() {
		return consumeCredits;
	}

	public void setConsumeCredits(Long consumeCredits) {
		this.consumeCredits = consumeCredits;
	}

	public Integer getConsumeMoney() {
		return consumeMoney;
	}

	public void setConsumeMoney(Integer consumeMoney) {
		this.consumeMoney = consumeMoney;
	}

	public Integer getVisitTimes() {
		return visitTimes;
	}

	public void setVisitTimes(Integer visitTimes) {
		this.visitTimes = visitTimes;
	}

	public Integer getWinTimes() {
		return winTimes;
	}

	public void setWinTimes(Integer winTimes) {
		this.winTimes = winTimes;
	}

	public Long getCredits() {
		return credits;
	}

	public void setCredits(Long credits) {
		this.credits = credits;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public String getRule() {
		return rule;
	}

	public void setRule(String rule) {
		this.rule = rule;
	}

	public String getExplainText() {
		return explainText;
	}

	public void setExplainText(String explainText) {
		this.explainText = explainText;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public Integer getFailCount() {
		return failCount;
	}

	public void setFailCount(Integer failCount) {
		this.failCount = failCount;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getActivityId() {
		return activityId;
	}

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Integer getActivityOrderQuantity() {
		return activityOrderQuantity;
	}

	public void setActivityOrderQuantity(Integer activityOrderQuantity) {
		this.activityOrderQuantity = activityOrderQuantity;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Integer getFreeLimit() {
		return freeLimit;
	}

	public void setFreeLimit(Integer freeLimit) {
		this.freeLimit = freeLimit;
	}

	public Integer getCreditsType() {
		return creditsType;
	}

	public void setCreditsType(Integer creditsType) {
		this.creditsType = creditsType;
	}

	public String getSubType() {
		return subType;
	}

	public void setSubType(String subType) {
		this.subType = subType;
	}

	public String getFreeScope() {
		return freeScope;
	}

	public void setFreeScope(String freeScope) {
		this.freeScope = freeScope;
	}

	public String getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(String limitScope) {
		this.limitScope = limitScope;
	}
	
	public int getAppItemSourceType() {
		switch (this.type) {
		case TypeDuibaActivity: // 专题活动 ok
			return AppItemDO.SourceTypeDuibaActivity;
		case TypeTurnTable: // 大转盘活动
			return AppItemDO.SourceTypeOperatingActivity;
		case TypeDuibaSingleLottery: // 兑吧单品抽奖 ok
			return AppItemDO.SourceTypeSingleLottery;
		case TypeAppSingleLottery: // App自有单品抽奖 ok
			return AppItemDO.SourceTypeSingleLottery;
		case TypeDuibaTurntable: // 兑吧大转盘 ok
			return AppItemDO.SourceTypeOperatingActivity;
		case TypeAppManualLottery: // app自有手动开奖 ok
			return AppItemDO.SourceTypeManualLottery;
		case TypeShakeLottery: // 摇一摇 ok
			return AppItemDO.SourceTypeOperatingActivity;
		case TypeScratchCard: // 刮刮卡 ok
			return AppItemDO.SourceTypeOperatingActivity;
		case TypeHdToolTurntable: // 活动工具大转盘 ok
			return AppItemDO.SourceTypeOperatingActivity;
		case TypeHdToolTiger: // 老虎机 ok
			return AppItemDO.SourceTypeOperatingActivity;
		case TypeSecondsKill: // 秒杀专题
			return AppItemDO.SourceTypeSecondsKill;
		case TypeGameSanta: // 圣诞游戏
			return AppItemDO.SourceTypeGameSanta;
		case TypeGameYearAward: // 数年终奖游戏
			return AppItemDO.SourceTypeGameYearAward;
		case TypeGameGirl: // 女神游戏
			return AppItemDO.SourceTypeGameGirl;
		case TypeDuibaQuestionAnswer: // 兑吧答题活动
			return AppItemDO.SourceTypeDuibaQuestionAnswer;
		case TypeDuibaQuizz://测试题活动
			return AppItemDO.SourceTypeDuibaQuizz;
		default:
			return 0;
		}
	}

	public int getAppBannerSourceType() {
		switch (this.type) {
		case TypeDuibaActivity: // 专题活动 ok
			return AppBannerDO.SourceTypeDuibaActivity;
		case TypeTurnTable: // 大转盘活动
			return AppBannerDO.SourceTypeOperatingActivity;
		case TypeDuibaSingleLottery: // 兑吧单品抽奖 ok
			return AppBannerDO.SourceTypeSingleLottery;
		case TypeAppSingleLottery: // App自有单品抽奖 ok
			return AppBannerDO.SourceTypeSingleLottery;
		case TypeDuibaTurntable: // 兑吧大转盘 ok
			return AppBannerDO.SourceTypeOperatingActivity;
		case TypeAppManualLottery: // app自有手动开奖 ok
			return AppBannerDO.SourceTypeManualLottery;
		case TypeShakeLottery: // 摇一摇 ok
			return AppBannerDO.SourceTypeOperatingActivity;
		case TypeScratchCard: // 刮刮卡 ok
			return AppBannerDO.SourceTypeOperatingActivity;
		case TypeHdToolTurntable: // 活动工具大转盘 ok
			return AppBannerDO.SourceTypeOperatingActivity;
		case TypeHdToolTiger: // 老虎机 ok
			return AppBannerDO.SourceTypeOperatingActivity;
		case TypeSecondsKill: // 秒杀专题
			return AppBannerDO.SourceTypeSecondsKill;
		case TypeGameSanta: // 圣诞游戏
			return AppBannerDO.SourceTypeGameSanta;
		case TypeGameYearAward: // 数年终奖游戏
			return AppBannerDO.SourceTypeGameYearAward;
		case TypeGameGirl: // 女神游戏
			return AppBannerDO.SourceTypeGameGirl;
		case TypeDuibaQuestionAnswer: // 兑吧答题游戏
			return AppBannerDO.SourceTypeDuibaQuestionAnswer;
		case TypeDuibaQuizz://测试题活动
			return AppBannerDO.SourceTypeDuibaQuizz;
		default:
			return 0;
		}
	}
}
