package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.item.domain.dataobject.DuibaTurntableDO;
import cn.com.duiba.service.item.domain.dataobject.TurntableAppSpecifyDO;
import cn.com.duiba.service.item.domain.dataobject.TurntableOptionsDO;
import cn.com.duiba.service.item.domain.vo.ActivityExtraInfoVO;
import cn.com.duiba.service.item.domain.vo.AddActivityVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 兑吧大转盘业务DAO
 */
public interface RemoteDuibaTurntableService {

	//DuibaTurntableSimpleDAO


	/**
	 * 查询一天内，需要定时下架的转盘抽奖
	 * @return
	 */
	public List<DuibaTurntableDO> findAutoOff();

	/**
	 * 通过ID查询兑吧幸运转盘
	 */
	public DuibaTurntableDO find(Long id) ;

	/**
	 * 幸运转盘分页列表
	 */
	public List<DuibaTurntableDO> findByLimit(Map<String, Object> params);

	/**
	 * 幸运转盘分页条数
	 */
	public Long countByLimit(Map<String, Object> params);

	/**
	 * 查询APP参与的活动
	 */
	public List<AddActivityVO> findAllDuibaTurntable(Long appId);

	/**
	 * 根据ID集合查询
	 */
	public List<DuibaTurntableDO> findAllByIds(List<Long> ids);

	/**
	 * 模糊搜索的分页查询
	 */
	public List<DuibaTurntableDO> findByTurntableLimit(Map<String, Object> paramMap);

	/**
	 * 模糊搜索的分页条数
	 */
	public Long getCountDuibaTurntable(Map<String, Object> paramMap);

	/**
	 * 根据定向ID查询定向关系
	 */
	public TurntableAppSpecifyDO findSpecifyById(Long id);

	/**
	 * 根据兑吧转盘ID查询定向APP
	 */
	public List<TurntableAppSpecifyDO> findAppSpecifyByTurntableId(Long turntableId);

	/**
	 * 根据活动ID，APP查询定向关系
	 */
	public TurntableAppSpecifyDO findSpecifyByTurntableAndApp(Long turntableId, Long appId);
	
	/**
	 * 通过ID查询兑吧幸运转盘
	 */
	public ActivityExtraInfoVO findExtraInfoById(Long id);


	//DuibaTurntableTextChangeDAO

	public int updateAutoOffDateNull(Long id);

	/**
	 * 新增兑吧幸运转盘
	 */
	public DuibaTurntableDO insert(DuibaTurntableDO duibaTurntableDO);

	/**
	 * 修改兑吧幸运转盘
	 */
	public int update(DuibaTurntableDO duibaTurntableDO);

	/**
	 * 删除APP定向关系
	 */
	public int deleteAppSpecify(Long id);

	/**
	 * 添加app定向关系
	 */
	public void insertAppSpecify(TurntableAppSpecifyDO appSpecifyDO);

	/**
	 * 减奖品数量
	 */
	public int decrementOptionRemaining(Long id);

	/**
	 * 加奖品数量
	 */
	public int incrementOptionRemaining(Long id);
}
