package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DuibaHdtoolDO;
import cn.com.duiba.service.domain.dataobject.DuibaHdtoolOptionsDO;
import cn.com.duiba.service.domain.dataobject.HdtoolAppSpecifyDO;
import cn.com.duiba.service.item.domain.vo.ActivityExtraInfoVO;
import cn.com.duiba.service.item.domain.vo.AddActivityVO;

import java.util.List;
import java.util.Map;

/**
 * 兑吧活动工具业务DAO
 */
public interface RemoteDuibaHdtoolService {
	
	/**
	 * 查询一天内，需要定时下架的转盘抽奖
	 * @return
	 */
	public List<DuibaHdtoolDO> findAutoOff();

	/**
	 * 根据ID查询
	 */
	public DuibaHdtoolDO find(Long id);

	/**
	 * 活动工具分页列表
	 */
	//Start chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30
	public List<DuibaHdtoolDO> findDuibaHdToolsList(Map<String, Object> paramMap);

	/**
	 * 统计活动工具条数
	 */
	public Integer countDuibaHdToolsList(Map<String, Object> queryMap);

	/**
	 * 根据APP查询活动工具
	 */
	public List<AddActivityVO> findAllDuibaHdTools(Long appId);

	/**
	 * 根据ID集合查询活动工具
	 */
	public List<DuibaHdtoolDO> findAllByIds(List<Long> ids);

	/**
	 * 根据活动ID查询奖项
	 */
	public List<DuibaHdtoolOptionsDO> findOptionsByDuibaHdtoolId(Long hdtoolId);

	/**
	 * 查询活动奖项个数
	 */
	public Integer countOptionsByHdtoolId(Long hdtoolId);

	/**
	 * 根据ID查询
	 */
	public DuibaHdtoolOptionsDO findOptionById(Long id);
	
	/**
	 * 根据活动ID查询定向
	 */
	public List<HdtoolAppSpecifyDO> findAllSpecifyByHdToolId(Long hdToolId);

	/**
	 * 根据活动ID或APP查询定向关系
	 */
	public HdtoolAppSpecifyDO findSpecifyByHdToolIdAndApp(Long duibaHdToolId, Long appId);

	/**
	 * 根据ID查询定向关系
	 */
	public HdtoolAppSpecifyDO findSpecifyById(Long id);
	
	/**
	 * 根据ID查询额外信息
	 */
	public ActivityExtraInfoVO findExtraInfoById(Long id);


	/**
	 * 查询item是否被活动工具使用
	 *
	 * @param itemId
	 * @return
	 */
	public List<Long> findHasUserdHdIds(Long itemId);

	/**
	 * @param queryMap
	 * @return
	 */
	public Long getCountDuibaHdTool(Map<String, Object> queryMap);

	/**
	 * @param queryMap
	 * @return
	 */
	public List<DuibaHdtoolDO> findDuibaToolList(Map<String, Object> queryMap);

	//from DuibaHdtoolTextChangeDao


	public int updateAutoOffDateNull(Long id);

	/**
	 * 新增兑吧活动工具
	 */
	public DuibaHdtoolDO insert(DuibaHdtoolDO duibaHdtoolDO);

	/**
	 * 删除兑吧活动
	 */
	public int deleteById(Long id);

	/**
	 * 修改兑吧活动工具
	 */
	public int update(DuibaHdtoolDO duibaHdtoolDO);

	/**
	 * 修改活动工具状态
	 */
	public int updateStatus(Long id, Integer status);

	/**
	 * 减奖品数量
	 */
	public int decrementOptionRemaining(Long id);

	/**
	 * 加奖品数量
	 */
	public int incrementOptionRemaining(Long id);

	/**
	 * 删除奖项
	 */
	public int deleteOptions(List<Long> ids);

	/**
	 * 修改奖项
	 */
	public int updateHdtoolPrize(DuibaHdtoolOptionsDO duibaHdToolOptionDO);

	/**
	 * 新增兑换活动工具奖项
	 */
	public DuibaHdtoolOptionsDO insertHdtoolOption(DuibaHdtoolOptionsDO duibaHdToolOptionDO);

	/**
	 * 修改兑吧活动工具
	 */
	public int updateHdtoolOption(DuibaHdtoolOptionsDO duibaHdToolOptionDO);

	/**
	 * 删除定向关系
	 */
	public int deleteSpecifyById(Long id);

	/**
	 * 添加定向关系
	 */
	public HdtoolAppSpecifyDO insertSpecify(HdtoolAppSpecifyDO hdtoolAppSpecifyDO);

}
