package cn.com.duiba.service.domain.vo;

import cn.com.duiba.service.domain.dataobject.AppDO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.*;
import java.util.Map.Entry;

public class PriceDegree implements Serializable{
	private static final long serialVersionUID = 8614191928238933072L;
	/**
	 * 档位->(credits->积分，title->文案)
	 */
	private TreeMap<String,Map<String,String>> customDegree;
	
	public static final String PRICE_KEY="price";
	public static final String CREDITS_KEY="credits";
	public static final String TITLE_KEY="title";
	public static final String LIMITCOUNT_KEY="limitCount";
	public static final String LIMITSCOPE_KEY="limitScope";
	
	private static Comparator<String> comparator=new Comparator<String>() {
		public int compare(String o1, String o2) {
			try {
				Long o1l=Long.valueOf(o1);
				Long o2l=Long.valueOf(o2);
				return o1l.compareTo(o2l);
			} catch (NumberFormatException e) {
				return o1.compareTo(o2);
			}
		}
	};
	
	public PriceDegree(String[] cps){
		TreeMap<String,Map<String,String>> map = new TreeMap<String,Map<String,String>>(comparator);
		for(String cp:cps){
			Map<String,String> hashmap = new HashMap<String,String>();
			if(cp.split(":").length>2){
				hashmap.put(CREDITS_KEY, cp.split(":")[1]);
				hashmap.put(TITLE_KEY, cp.split(":")[2]);
				map.put(cp.split(":")[0],hashmap);
			}else if(cp.split(":").length==2){
				hashmap.put(CREDITS_KEY, cp.split(":")[1]);
				map.put(cp.split(":")[0], hashmap);
			}else{
				hashmap.put(CREDITS_KEY, null);
				map.put(cp.split(":")[0], hashmap);
			}
		}
		this.customDegree = map;
	}
	
	/**
	 * 反序列化构造方法
	 * @param customDegreeStr
	 */
	public PriceDegree(String customDegreeStr){
		TreeMap<String,Map<String,String>> map = new TreeMap<String,Map<String,String>>(comparator);
		JSONArray ja = JSON.parseArray(customDegreeStr);
		for (int i = 0; i < ja.size(); i++) {
			Map<String,String> hashmap = new HashMap<String,String>();
			if(ja.getJSONObject(i).getString(LIMITCOUNT_KEY)!=null){
				hashmap.put(CREDITS_KEY, getDegreeCredits(ja.getJSONObject(i).getString(CREDITS_KEY)));
				hashmap.put(LIMITCOUNT_KEY, ja.getJSONObject(i).getString(LIMITCOUNT_KEY));
				hashmap.put(LIMITSCOPE_KEY, ja.getJSONObject(i).getString(LIMITSCOPE_KEY));
				map.put(ja.getJSONObject(i).getString(PRICE_KEY),hashmap);
			}else if(ja.getJSONObject(i).getString(TITLE_KEY)!=null){
				hashmap.put(CREDITS_KEY, getDegreeCredits(ja.getJSONObject(i).getString(CREDITS_KEY)));
				hashmap.put(TITLE_KEY, ja.getJSONObject(i).getString(TITLE_KEY));
				map.put(ja.getJSONObject(i).getString(PRICE_KEY),hashmap);
			}else{
				hashmap.put(CREDITS_KEY, getDegreeCredits(ja.getJSONObject(i).getString(CREDITS_KEY)));
				map.put(ja.getJSONObject(i).getString(PRICE_KEY),hashmap);
			}
		}
		this.customDegree = map;
	}
	
	private String getDegreeCredits(String creditsStr){
		if(creditsStr==null || StringUtils.isBlank(creditsStr.trim())){
			return null;
		}else{
			return creditsStr.trim();
		}
	}
	
	/**
	 * 判断面额是否存在
	 * @param degree
	 * @return
	 */
	public boolean isDegreeExist(String degree) {
		return customDegree.containsKey(degree);
	}
	
	/**
	 * 序列化为json格式的String，用于保存。
	 * @return
	 */
	public String serializePriceDegree(){
		JSONArray ja = new JSONArray();
		for (Entry<String,Map<String,String>> entry : customDegree.entrySet()) {  
            JSONObject jo = new JSONObject();
            jo.put(PRICE_KEY, entry.getKey());
            jo.put(CREDITS_KEY, entry.getValue().get(CREDITS_KEY));
            jo.put(TITLE_KEY, entry.getValue().get(TITLE_KEY));
            jo.put(LIMITCOUNT_KEY, entry.getValue().get(LIMITCOUNT_KEY));
            jo.put(LIMITSCOPE_KEY, entry.getValue().get(LIMITSCOPE_KEY));
            ja.add(jo);
        } 
		return ja.toString();
	}
	
	public void serializeUp200Alipay() throws Exception{
		for (Entry<String,Map<String,String>> entry : customDegree.entrySet()) {  
            if(Integer.parseInt(entry.getKey()) > 200){
            	throw new Exception("支付宝面值不能大于200");
            }
        }
	}
	
	/**
	 * 根据档位获取积分
	 * @param degree
	 * @return
	 */
	public String getCreditsByDegree(String degree){
		return ((TreeMap<String,Map<String,String>>) customDegree).get(degree).get(CREDITS_KEY);
	}
	
	/**
	 * 根据档位获取文案
	 * @param degree
	 * @return
	 */
	public String getTitleByDegree(String degree){
		return ((TreeMap<String,Map<String,String>>) customDegree).get(degree).get(TITLE_KEY);
	}
	
	/**
	 * 根据档位获取 限制数和限制类型
	 * @param degree
	 * @return
	 */
	public Map<String, String> getLimitByDegree(String degree){
		return ((TreeMap<String,Map<String,String>>) customDegree).get(degree);
	}
	
	/**
	 * 取出最小的档位key
	 * @return
	 */
	public String getMinDegreeKey(){
		return ((TreeMap<String,Map<String,String>>) customDegree).firstKey();
	}
	
	public Integer getMinDegreeInt(){
		return Integer.valueOf(getMinDegreeKey());
	}
	
	/**
	 * 取出最小的档位value的积分
	 * @return
	 */
	public String getMinDegreeCredits(){
		String minDegreeCredits = ((TreeMap<String,Map<String,String>>) customDegree).firstEntry().getValue().get(CREDITS_KEY);
		
		if(StringUtils.isBlank(minDegreeCredits)){
			return null;
		}else{
			Iterator it = customDegree.keySet().iterator();
			String temp = "";
	        while (it.hasNext()) {  
	        	Map<String,String> ent=(Map<String,String>)customDegree.get(it.next());
	        	if(StringUtils.isBlank(temp)){
	        		temp = ent.get(CREDITS_KEY);
	        	}else{
		        	if(!StringUtils.isBlank(ent.get(CREDITS_KEY)) && Long.valueOf(temp).compareTo(Long.valueOf(ent.get(CREDITS_KEY))) > 0){
		        		temp = ent.get(CREDITS_KEY);
		        	}
	        	}
	        }
	        if(StringUtils.isBlank(temp)){
	        	return minDegreeCredits;
	        }else{
	        	return temp;
	        }
		}		 
	}
	
	
	static class CreditsComparator implements Comparator,Serializable {
		private static final long serialVersionUID = -2414083834670521985L;

		public int compare(Object object1, Object object2) {// 实现接口中的方法
        	String p1 = (String) object1; // 强制转换  
        	String p2 = (String) object2;  
            return p2.compareTo(p1);  
        }  
    } 
	
	/**
	 * 取出最小的档位value的文案
	 * @return
	 */
	public String getMinDegreeTitle(){
		return ((TreeMap<String,Map<String,String>>) customDegree).firstEntry().getValue().get(TITLE_KEY);
	}
	
	public TreeMap<String,Map<String,String>> getCustomDegreeMap(){
		return (TreeMap<String,Map<String,String>>)customDegree;
	}
	
	/**
	 * 取出最小的积分
	 * @return
	 */
	public Long getMinCredits(AppDO app){
		Long a = 0L;
		for (String v : customDegree.keySet()) {
			if(a==0L){
				if(customDegree.get(v).get(CREDITS_KEY)!=null){
					a = Long.valueOf(customDegree.get(v).get(CREDITS_KEY));
				}else{
					a = Long.valueOf(v) * Long.valueOf(app.getCreditsRate());
				}
			}else{
				if(customDegree.get(v).get(CREDITS_KEY)!=null){
					if(a>Long.valueOf(customDegree.get(v).get(CREDITS_KEY))){
						a=Long.valueOf(customDegree.get(v).get(CREDITS_KEY));
					}
				}else{
					if(a>Long.valueOf(v) * Long.valueOf(app.getCreditsRate())){
						a = Long.valueOf(v) * Long.valueOf(app.getCreditsRate());
					}
				}
			}
		}
		return a;
	}

	/**
	 * 判断是否单一档位
	 * @return
	 */
	public boolean isSingleDegree(){
		if(customDegree.size()==1){
			return true;
		}else{
			return false;
		}
	}
	
	public Map<String,Map<String,String>> getCustomDegree() {
		return customDegree;
	}
	
}
