package cn.com.duiba.service.domain.vo;

import cn.com.duiba.service.domain.dataobject.AppShowcaseContentDO;
import cn.com.duiba.wolf.utils.DateUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by wenqi.huang on 16/5/13.
 */
public class ShowcasePreviewVO implements Serializable{
    private static final long serialVersionUID = 15763234212321L;

    private Long appShowcaseContentId;
    private Date startTime; // 橱窗的开始时间
    private String startTimeStr;
    private String mainTitle;
    private String mainTitleColor;
    private String subTitle;
    private Long showCredits; // 橱窗的展示积分
    private String indexImage;
    private Integer place; // 橱窗的位置

    private Boolean needTime; // 是否展示倒计时

    public ShowcasePreviewVO(AppShowcaseContentDO p) {
        this.appShowcaseContentId = p.getId();
        this.startTime = p.getStartTime();
        this.startTimeStr = DateUtils.getSecondStr(this.startTime);
        this.mainTitle = p.getMainTitle();
        this.mainTitleColor = p.getMainTitleColor();
        this.subTitle = p.getSubTitle();
        this.showCredits = p.getShowCredits();
        this.indexImage = p.getIndexImage();
        this.place = p.getPlace();
    }

    public String getStartTimeStr() {
        return startTimeStr;
    }

    public void setStartTimeStr(String startTimeStr) {
        this.startTimeStr = startTimeStr;
    }

    public Long getAppShowcaseContentId() {
        return appShowcaseContentId;
    }

    public void setAppShowcaseContentId(Long appShowcaseContentId) {
        this.appShowcaseContentId = appShowcaseContentId;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getMainTitle() {
        return mainTitle;
    }

    public void setMainTitle(String mainTitle) {
        this.mainTitle = mainTitle;
    }

    public String getMainTitleColor() {
        return mainTitleColor;
    }

    public void setMainTitleColor(String mainTitleColor) {
        this.mainTitleColor = mainTitleColor;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public Long getShowCredits() {
        return showCredits;
    }

    public void setShowCredits(Long showCredits) {
        this.showCredits = showCredits;
    }

    public String getIndexImage() {
        return indexImage;
    }

    public void setIndexImage(String indexImage) {
        this.indexImage = indexImage;
    }

    public Integer getPlace() {
        return place;
    }

    public void setPlace(Integer place) {
        this.place = place;
    }

    public Boolean getNeedTime() {
        return needTime;
    }

    public void setNeedTime(Boolean needTime) {
        this.needTime = needTime;
    }

}
