package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/4/26.
 */
public interface RemoteAppItemService {

    //AppItemActivityDAO
    /**
     * 获取开启状态的抽奖活动的appItem入口
     */
    public List<Long> findIdsByOpenLotteryIds(List<Long> openOaIds);

    /**
     * 查询活动兑换项
     */
    public List<AppItemDO> findAllBySourceTypeAndRelationIdAndDeleted(Integer sourceType, Long sourceRelationId, Boolean deleted);

    /**
     * 获取专题活动在所有app那边已经主推（包括删除）的appItem
     */
    public List<AppItemDO> findAllDuibaActivityAppItem(List<Long> itemIds, Long appId);

    /**
     * 根据title和type查询列表
     */
    public List<AppItemDO> findAllOwnerByTitleAndTypeAndAppId4ASL(String title, String type, Long appId);

    /**
     * 根据title和type查询列表
     */
    public List<AppItemDO> findAllNotOwnerByTitleAndTypeAndAppId4ASL(String title, String type, Long appId);

    //AppItemRepoDAO

    /**
     * 查询数量
     */
    public Long countRow(Map<String, Object> params);

    /**
     * 分页查询
     */
    public List<AppItemDO> findByLimit(Map<String, Object> params);

    /**
     * 查询不可用的商品的id 集合
     *
     * @author 方雄韬 2014年12月10日
     * @param subStatus
     */
    public List<Long> findInvalidAppItemIds(Long appId, String subStatus);

    /**
     * 查询上架的自有Type兑换类型商品
     *
     * @author 方雄韬 2014年12月10日
     */
    public List<AppItemDO> findAllByTypeAndIsOwnerAndStatus(String type, Boolean isOwner, String status);

    /**
     * pId
     */
    public List<Long> selectHasUpItems(List<Long> ids, Long appId);

    /**
     *
     */
    public AppItemDO selectItemStore(Long appId, Long itemId);

    /**
     * 根据appId获取兑换项列表（不包含活动兑换项入口）
     */
    public List<AppItemDO> findAllByAppIdAndTypeIn(Long appId);

    /**
     *
     */
    public List<AppItemDO> findAllUpVirtaulAppItems(Long appId);

    /**
     *
     */
    public List<AppItemDO> findAllVirtualValid(Long appId);

    /**
     *
     */
    public List<AppItemDO> findhomeAppItemNeed(Long appId);

    public List<AppItemDO> findhomeAppItemNeedOfPptv(Long appId);

    //AppItemScheduledTasksDAO
    /**
     * 获取所有app任务内容
     */
    public List<AppItemDO> findAllAppTasksContent(Long appId);

    /**
     * 计划任务用查询是否在库中
     */
    public AppItemDO selectItemStore4Task(Long appId, Long itemId);

    //AppItemSimple

    /**
     * 根据ID查询
     */
    public AppItemDO find(Long id);

    /**
     *
     */
    public AppItemDO insert(AppItemDO appItem);

    /**
     *
     */
    public void update(AppItemDO appItem);

    /**
     * 根据itemIds in 和appId
     */
    public List<AppItemDO> findAllByItemIdsAndAppId(List<Long> itemIds, Long appId);

    /**
     * 根据IDS IN
     */
    public List<AppItemDO> findAllByIds(List<Long> ids);

    /**
     * 根据app和item 查找已经上架中的 appitem
     */
    public AppItemDO findByAppAndItemOnline(Long appId, Long itemId);

    /**
     * 根据itemId查询
     */
    public List<AppItemDO> findAllByItemId(Long itemId);

    /**
     * 根据app和item 查找appitem 不考虑上下架，删除等状态
     */
    public AppItemDO findByAppIdAndItemId(Long appId, Long itemId);

    /**
     * 根据appId和Type查询全部
     */
    public List<AppItemDO> findAllByAppIdAndType(Long appId, String type);

    /**
     * 根据appId type查询
     */
    public List<AppItemDO> findAllByAppIdAndInType(Long appId, String[] type);

    /**
     * 根据类型(数组)查找appIitem
     *
     * @author 方雄韬 2014年12月10日
     * @param type
     * @return
     */
    public List<AppItemDO> findAllByInType(String[] type);

    /**
     * 根据APP、是否自有 查询商品列表
     *
     * @author 方雄韬 2014年12月11日
     * @param appId
     * @param isOwner
     * @return
     */
    public List<AppItemDO> findAllByAppAndIsOwner(Long appId, Boolean isOwner);

    /**
     * @AUTH: ZhangPan
     * @Date: 2014年12月29日 下午2:31:23
     * @Description:根据兑换项id查询该兑换项是否被开发者使用
     */
    public Integer findCountByItemId(Long itemId);

    /**
     * 获取上架中的兑换项数量，不包含活动兑换项入口
     */
    public Integer findOnlineCount(Long appId);

    /**
     * item禁用日志需求，根据itemId获取上架状态的appItem
     */
    public List<AppItemDO> findOnShelfByItemId(Long itemId);

    /**
     * 根据兑吧兑换项ID查询所有appId
     */
    public List<Long> findAppIdByItemIds(List<Long> itemIds);

    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type);

    public List<Long> findAppIdsByActivityId(Long relationId);

    public List<Long> findAppIdsByIds(List<Long> ids);

    /**
     * 查询自有过期产品（7天 < valid_end_date < new Date）
     */
    public List<AppItemDO> findSelfOverdueAppItem(String type);

    /**
     * 查询一天内定时下架的兑换项（优惠券，实物, 虚拟商品, 直充类, 单档位直充）
     */
    public List<AppItemDO> findAutoOffAppItem();

    /**
     * 兑换项分页查询
     */
    public List<AppItemDO> findAppItemLimit(Map<String, Object> param, int start, int pageSize);

    /**
     * 兑换项分页总条数
     */
    public Long findAppItemCount(Map<String, Object> param);

    /**
     * 查询app所有兑换项
     */
    public List<AppItemDO> findAllAppItem(Map<String, Object> param);

    /**
     * 根据appId查询
     */
    public List<AppItemDO> findAllByAppId(Long appId);

    /**
     * 根据expressTemplateId查询
     * @param expressTemplateId
     * @return
     */
    public List<AppItemDO> findAllByExpressTemplateId(Long expressTemplateId);

    //AppItemSpmDAO

    /**
     * 分页查询的行计数
     * @author 方雄韬 2014年12月10日
     * @param queryPublish
     * @return
     */
    public Long countPublishItemRow(Map<String, Object> queryPublish);

    /**
     * publishItem分页查询
     * @author 方雄韬 2014年12月9日
     * @param queryPublish
     * @return
     */
    public List<AppItemDO> findPublishItemLimit(Map<String, Object> queryPublish);

    //AppItemStatusChangeDAO

    /**
     * 根据活动ID更新状态
     */
    public Integer updateStatusByActivityId(String status, Boolean delete, Long activityId, Integer type);

    /**
     * 删除运营活动兑换项
     */
    public Integer updateStatusByOperationActivityId(String status, Boolean delete, Long relationId);

    /**
     * 库存减一 一般用于自有实物在下单阶段被调用
     *
     * @param appItemId
     * @return 影响行数，如果返回0，表示库存不足执行失败
     */
    public int reduceRemaining(Long appItemId);

    /**
     * 库存加一 一般用于自有实物在下单失败，或者兑换失败阶段被调用
     *
     * @param appItemId
     */
    public int increaseRemaining(Long appItemId);

    /**
     * 自有实物失败返还库存 自有券
     *
     * @param appItemId
     */
    public void turnbackAppitemRemaining(Long appItemId);

    /**
     * 自有券减库存
     */
    public void decreaseAppitemRemaining(Long appItemId);

    /**
     * 更新批次
     */
    public void updateBatchIdById(Long id, Long batchId);

    /**
     * 上架或者下架
     */
    public void standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay);

    /**
     * 删除或者恢复兑换项
     */
    public void deleteOrRecoverAppItem(Long id, Boolean deleted, String status);

    /**
     * 更新积分
     */
    public void updateCreditsById(Long id, Long credits);

    /**
     * 更新库存
     */
    public void updateRemainingById(Long id, Integer remaining);

    /**
     * 更新状态
     */
    public int updateStatusAndSubStatusById(Long id, String status, String subStatus);

    /**
     * 更新积分和customPrice
     */
    public void updateCreditsAndCustomPriceById(Long id, Long credits, String customPrice);

    /**
     * 减少库存
     */
    public int subRemainingById(Long id, Integer subRemaining);

    /**
     * 增加库存
     */
    public int addRemainingById(Long id, Integer addRemaining);

    /**
     * 根据ItemId 下架，失效所有开发者引用商品
     */
    public int updateStatusAndSubStatusByItemId(Long itemId, String status, String subStatus);

    //AppItemTextChangeDAO

    public int updateAutoOffDateNull(Long id);

    /**
     * 删除推送的
     */
    public void deletePushAppItem(List<Long> ids);

    /**
     * 根据item查询所有过期的appitem 将item旗下所有APPItem 设置substatus=null 表示没过期
     */
    public void updateExpiedAppItem(Long itemId);

    /**
     * APPItem 设置substatus=null 表示没过期
     */
    public int updateExpiedAppItemById(Long appItemId);

    /**
     * 从兑吧库添加到开发者库
     * 将title、subtitle、description、credits、logo、smallImage、image、multiImage
     * 、bannerImage置空。
     *
     * @author 方雄韬 2015年1月23日
     */
    public void setMyRepoMultiNull(Long appItemId);

    /**
     * 将LimitTimeBetween为null
     *
     * @param appItemId
     */
    public void setLimitNull(Long appItemId, Integer limitCount, String limitTimeBetween, Integer limitEverydayQuantity);

    /**
     * 删除商品的时候，将图片置空。
     *
     * @author 方雄韬 2014年12月30日
     * @param appItemId
     */
    public void setImageNull(Long appItemId);

    /**
     * 修改兑换项 subStauts：expired（过期）状态为 null
     *
     * @param appItemId
     */
    public void setSubStatusNull(Long appItemId);

    /**
     * 更新专题活动主推兑换项属性
     */
    public void updateMainPushAppItem(Long id, String title, String logo, String smallImage,String whiteImage, String bannerImage, Long credits, String subtitle);

    /**
     * 更新活动工具兑换项入口
     */
    public void updateHdtoolAppItem(Long id, String title, String smallImage,String whiteImage, Long credits, String customPrice,String logo);

    /**
     * 更新活动工具兑换项入口信息
     */
    public void updateAppItemSourceType(Long id, Long credits, Date gmtModified, Integer sourceType, String title);

    /**
     * 更新有效时间
     */
    public void updateValidEndDate(Long id, Date validEndDate);

    /**
     * 更新customPrice
     */
    public void updateCustomPrice(Long id, String customPrice);

    /**
     * 更新运营活动状态
     */
    public void updateOperationsTypeById(Long id, Integer operationsType);

    /**
     * 更新活动兑换项状态
     */
    public void updateActivityAppItem(Long id, String title, String subtitle, String logo, String smallImage,String whiteImage);

    /**
     * 更新大转盘兑换项的状态
     */
    public void updateTurntableAppItem(Long id, String title, String subtitle, String logo, String smallImage,String whiteImage, Long credits, String customPrice);

    /**
     * 更新subType
     */
    public int updateSubTypeById(Long id, Integer subType);

    /**
     * 更新库存，过期时间
     */
    public int updateRemainingAndvalidEndDate(Long id, Integer remaining, Date validEndDate);


    /**
     * AppItemDO(id,appId),找出appId是为了进行权限验证
     */
    public List<AppItemDO> findIdAndAppId4AppItem(List<Long> appItemIds);

    public int updateAppItemPayload(Long appId,Long appItemId,Integer payload) throws Exception;

    /**
     * 得到appItem置顶项的数目
     * @param appId
     * @return
     */
    public int getTopNumByAppId(Long appId);

    /**
     * 得到普通上架项中的最大的权重
     * @param appId
     * @return
     */
    public int findAppMaxPayload(Long appId);

    public List<Long> findTopAppItemDesc(Long appId);

    /**
     * 自动修复兑吧已经禁用的商品
     *
     *
     * 比如：
     * 商品被添加到AppItem，而后兑吧禁用或者删除了该商品，此时在AppItem库中，该商品还是上架状态。
     * 此时进行修复，将该商品标记为下架状态
     *
     * 使用场景：当开发者在后台调整首页兑换项顺序时触发该程序
     */
    public int updateOfflineAppItem4Disable(Long appId);

    /**
     * 查询app 上架，且首页展示的兑换项
     */
    public List<ItemKey> findHomeItemKeyByCache(AppDO app);

    /**
     * 首页banner,icon 根据appItemId IN 查询缓存
     */
    public List<AppItemDO> findBannerIconAppItemByCache(Long appId, List<Long> appItemIds);

    /**
     * 查询app 上架，且首页展示的兑换项
     *
     * @param app
     * @return
     */
    public List<ItemKey> findAppItemToItemKey(AppDO app);

    /**
     * 保存/修改 大转盘appItem
     *
     * @param appItem
     * @param turntableId
     */
    public void saveAppItemByTurntable(AppItemDO appItem, long turntableId);

    /**
     * 保存/修改 大转盘appItem
     */
    public void saveAppItemByTurntableNoTranscation(AppItemDO appItem, long turntableId);

    /**
     * 上架或者下架
     */
    public void standUpOrDown(Long appId, Long appItemId, String status) throws BusinessException;

    /**
     * 删除appItem
     *
     * @param appId
     * @param appItemId
     */
    public void deleteAppItem(Long appId, Long appItemId);

    /**
     * 根据类型添加兑换项到 开发者库
     *
     * @param appId
     * @param type
     * @return
     */
    public AppItemDO saveAppItemByActivity(Long appId, String type, Boolean delete);

    /**
     * 获取库存不足的兑换项的数量
     */
    public Integer getRemaining0Count(Long appId);

    public void updateAppItemByTurntable(AppItemDO appItem, long turntableId) throws BusinessException;

    public void updateAppItemByTurntableNoTranscation(AppItemDO appItem, long turntableId) throws BusinessException;

    /**
     * 商品项批量上架
     * @param appId
     * @param appItemIds
     * @return 成功条数
     */
    public int bathcStandUp(AppDO app, List<Long> appItemIds);

    /**
     * 增加一个测试商品
     */
    public void addTestAppItem(Long appId);

    /**
     * 获取appItemId
     */
    public Long getOrAddAppItemId(Integer type, Long appId);

    /**
     * 分类下兑换项排序
     */
    public int sortClassifyAppItem(Long classifyId, List<Long> appItemIds);

    /**
     * 迁移来自CouponCtrl.doUpdateCoupon from developer,
     * @param appItem
     * @param exchangeLimit
     * @param arealimitSwitch
     * @param arealimitType
     * @param arealimitAreas
     * @param usePrompt
     * @param btnText
     */
    public void doUpdateCoupon(AppItemDO appItem, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas, String usePrompt, String btnText);

    /**
     * 迁移来自ObjectCtrl.doUpdateOwnerObject from developer
     * @param appItem
     * @param preRemaining
     * @param remaining
     * @param exchangeLimit
     * @param arealimitSwitch
     * @param arealimitType
     * @param arealimitAreas
     * @throws BusinessException
     */
    public void doUpdateOwnerObject(AppItemDO appItem, Integer preRemaining, Integer remaining, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas) throws BusinessException;

    /**
     * 来自VirtualCtrl.doUpdateVirtual from developer
     * @param appItem
     * @param preRemaining
     * @param remaining
     * @param isOnSale
     * @throws BusinessException
     */
    public void doUpdateVirtual(AppItemDO appItem, Integer preRemaining, Integer remaining, boolean isOnSale) throws BusinessException;

    /**
     * 来自 DmyrepoCtrl.doBtachDel from developer
     * 软删除多个appItem
     * @param appId
     * @param developerId
     * @param appItemIds
     * @throws BusinessException
     */
    public void doBatchDel(Long appId, Long developerId, List<Long> appItemIds) throws BusinessException;
}
