package cn.com.duiba.service.remoteservice;


import cn.com.duiba.service.exception.BusinessException;

/**
 * 单品抽奖库存消费
 * @author zp
 *
 */
public interface RemoteSingleLotteryStockConsumeService {

	/**
	 * 兑吧单品抽奖消费库存,大奖，小奖
	 * @param duibaSingleLotteryId
	 * @param appId
	 */
	public void consumeDuibaSingleLotteryStock(Long duibaSingleLotteryId, Long appId, Integer optionType, String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 返单品抽奖消费库存，大奖，小奖
	 * @param bizId
	 * @param bizSource
	 */
	public void paybackDuibaSingleLotteryStock(String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 消费兑吧单品定向库存
	 * @param duibaSingleLotteryId
	 * @param appId
	 * @param bizId
	 * @param bizSource
	 */
	public void consumeSingleLotterySpecifyStock(Long duibaSingleLotteryId, Long appId, String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 返兑吧单品定向库存
	 * @param bizId
	 * @param bizSource
	 */
	public void paybackSingleLotterySpecifyStock(String bizId, String bizSource) throws BusinessException;
	
	
	/**
	 * 开发者自有单品抽奖消费库存，大奖
	 */
	public void consumeDevSingleLotteryStock(Long appSingleLotteryId, Long appId, String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 返开发者单品抽奖消费库存，大奖
	 * @param bizId
	 * @param bizSource
	 */
	public void pabackDevSingleLoteryStock(String bizId, String bizSource) throws BusinessException;
	
}
