package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;
import cn.com.duiba.wolf.utils.UrlUtils;
import com.sun.jndi.toolkit.url.UrlUtil;

import java.util.Date;
import java.util.Map;

public class ConsumerExtraDO extends BaseDO {

	private static final long serialVersionUID = -4728874257710900628L;

	public static final int SEX_MALE = 1; // 男性

	public static final int SEX_FEMALE = 2; // 女性
	public static final String[] INCLUDE_TAGS = {"nickname", "avatar"};	// 用户包含的信息

	private Long id;

	private Long consumerId;

	private Long appId;

	private String partnerUserId;

	private String nickname; // 昵称

	private String avatar; // 头像

	private String email; // 邮箱

	private Integer sex; // 性别 1男性 2女性

	private String json;

	private Date gmtCreate;

	private Date gmtModified;

	public ConsumerExtraDO() {
	}

	public ConsumerExtraDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public ConsumerExtraDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public String getPartnerUserId() {
		return partnerUserId;
	}

	public void setPartnerUserId(String partnerUserId) {
		this.partnerUserId = partnerUserId;
	}

	public String getNickname() {
		return nickname;
	}

	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Integer getSex() {
		return sex;
	}

	public void setSex(Integer sex) {
		this.sex = sex;
	}

	public String getJson() {
		return json;
	}

	public void setJson(String json) {
		this.json = json;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public static boolean ifSave(String dcustom) {
		for (String tag : INCLUDE_TAGS) {
			if (dcustom.contains(tag)) {
				return true;
			}
		}
		return false;
	}
	
	public static Map<String, String> explainDcustom(String dcustom) {
		return UrlUtils.explainURLParams(dcustom);
	}
}
