package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DeveloperDO;
import cn.com.duiba.service.domain.queryparams.ADeveloperQueryEntity;

import java.util.Date;
import java.util.List;

/**
 * Created by wenqi.huang on 16/5/9.
 */
public interface RemoteDeveloperService {

    public DeveloperDO findByEmail(String email);

    public DeveloperDO find(Long id);


    /**
     * 根据email模糊查询
     */
    public List<DeveloperDO> findByEmailLike(String email);

    public List<DeveloperDO> findAllByIdList(List<Long> idList);

    /**
     * 管理员后台开发者分页
     */
    public List<DeveloperDO> findDeveloperPage(ADeveloperQueryEntity queryEntity);

    /**
     * 管理员后台开发者列表总数
     */
    public Long findDeveloperPageCount(ADeveloperQueryEntity queryEntity);

    public int updateDeveloperSwitch(Long id, Integer developerSwitch);

    public int updateLastRemindTime(Long id, Date lastRemindTime);

    public int updateRemindMoneyNameCompany(Long id, Integer remindMoney, String name, String company);

    public int updatePassword(Long id, String password);

    public int updateVerifyAndEnable(Long id, boolean verify, boolean enable);
}
