package cn.com.duiba.service.item.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

/**
 * 兑吧添加的单品抽奖
 */
public class DuibaSingleLotteryDO extends BaseDO {
	private static final long serialVersionUID = 7121752960738768900L;

	public static final String CONSUMER_DRAW_LIMIT_FOREVER = "forever";
	public static final String CONSUMER_DRAW_LIMIT_EVERYDAY = "everyday";

	public static final String FREE_LIMIT_FOREVER = "forever";
	public static final String FREE_LIMIT_EVERYDAY = "everyday";

	public static final Integer SWITCHES_DIRECT = 0; // 定向发放
	public static final Integer SWITCHES_DEV_BLACKLIST = 1; // 黑名单商品
	public static final Integer SWITCHES_FREE_RULE = 2; // 免费次数使用的活动规则
	public static final Integer SWITCHES_NEW = 3;//判断是否是新添加的活动-与管理员后台保持一致新添加活动大奖默认开启库存预分配功能

	public static final Integer STATUS_UNPUBLISH = 0; // 未发布
	public static final Integer STATUS_STARTUP = 1; // 开启
	public static final Integer STATUS_SHUTDOWN = 2; // 关闭

	public static final Integer OP_TYPE_ACTIVITY = 0; // 活动专用

	private Long id;

	private Long mainItemId; // 主奖品item_id

	private String mainItemDegree; // 主奖品档位

	private String mainItemRate; // 主奖品中奖率
	
	private Integer mainItemMinComein; // 主将保底人数

	private Integer mainItemRemaining; // 主奖品数量

	private Long inciteItemId; // 鼓励奖item_id

	private String inciteItemRate; // 鼓励奖中奖概率
	
	private Integer inciteItemMinComein;// 鼓励奖保底人数

	private Integer inciteItemRemaining; // 鼓励奖数量

	private Integer inciteItemConsumerWinLimit; // 每个用户抽中鼓励奖数量上限

	private String title; // 活动标题

	private Integer consumerDrawLimit; // 用户抽奖数限制

	private String consumerDrawLimitScope; // 用户抽奖数限制 每天/全局

	private Integer freeLimit; // 免费抽奖次数

	private String freeLimitScope; // 免费抽奖次数 每天/全局

	private Integer consumerWinLimit; // 用户中奖数限制

	private Integer everydayWinLimit; // 每日中奖限制

	private Integer switches; // 定向发放开关 第0位 1开启 0关闭

	private Integer creditsPrice; // 抽奖金额

	private String logo; // 图标

	private String smallImage; // 缩略图

	private String whiteImage; //白底缩略图

	private String image; // 详情图

	private String bannerImage; // 首页banner

	private Integer status; // 开启关闭发布状态 未发布0 开启1 关闭2

	private Boolean deleted; // 是否删除

	private String introduction; // 活动说明

	private Integer operationsType;

	private String subtitle;// 默认说明文字

	private String limitDateJson;// 限时抽奖,日期限制，时间限制，存放json

	private Date gmtCreate;

	private Date gmtModified;

	private String rateIntroduction;	// 概率说明
	
	private Date autoOffDate; //定时自动下架日期
	
	@Override
	public String toString() {
		return "DuibaSingleLotteryDO [id=" + id + ", title=" + title + "]";
	}

	public DuibaSingleLotteryDO() {
	}

	public DuibaSingleLotteryDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public DuibaSingleLotteryDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			status = 0;
			switches = 0;
			operationsType = 0;
			deleted = false;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public void openSwitch(int s) {
		int v = 1 << s;
		switches = switches | v;
	}

	public void closeSwitch(int s) {
		int v = 1 << s;
		v = ~v;
		switches = switches & v;
	}

	public boolean isOpenSwitch(int s) {
		int v = 1 << s;
		int ret = switches & v;
		return ret != 0;
	}

	public void grantOpTypeItem(int opType) {
		int v = 1 << opType;
		operationsType = operationsType | v;
	}

	public void ungrantOpTypeItem(int opType) {
		int v = 1 << opType;
		v = ~v;
		operationsType = operationsType & v;
	}

	public boolean isOpTypeItem(int opType) {
		int v = 1 << opType;
		int ret = operationsType & v;
		return ret != 0;
	}

	public String getRateIntroduction() {
		return rateIntroduction;
	}

	public void setRateIntroduction(String rateIntroduction) {
		this.rateIntroduction = rateIntroduction;
	}

	public Integer getOperationsType() {
		return operationsType;
	}

	public void setOperationsType(Integer operationsType) {
		this.operationsType = operationsType;
	}

	public String getLimitDateJson() {
		return limitDateJson;
	}

	public void setLimitDateJson(String limitDateJson) {
		this.limitDateJson = limitDateJson;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getMainItemId() {
		return mainItemId;
	}

	public void setMainItemId(Long mainItemId) {
		this.mainItemId = mainItemId;
	}

	public String getMainItemDegree() {
		return mainItemDegree;
	}

	public void setMainItemDegree(String mainItemDegree) {
		this.mainItemDegree = mainItemDegree;
	}

	public String getMainItemRate() {
		return mainItemRate;
	}

	public void setMainItemRate(String mainItemRate) {
		this.mainItemRate = mainItemRate;
	}

	public Integer getMainItemRemaining() {
		return mainItemRemaining;
	}

	public void setMainItemRemaining(Integer mainItemRemaining) {
		this.mainItemRemaining = mainItemRemaining;
	}

	public Long getInciteItemId() {
		return inciteItemId;
	}

	public void setInciteItemId(Long inciteItemId) {
		this.inciteItemId = inciteItemId;
	}

	public String getInciteItemRate() {
		return inciteItemRate;
	}

	public void setInciteItemRate(String inciteItemRate) {
		this.inciteItemRate = inciteItemRate;
	}

	public Integer getInciteItemRemaining() {
		return inciteItemRemaining;
	}

	public void setInciteItemRemaining(Integer inciteItemRemaining) {
		this.inciteItemRemaining = inciteItemRemaining;
	}

	public Integer getInciteItemConsumerWinLimit() {
		return inciteItemConsumerWinLimit;
	}

	public void setInciteItemConsumerWinLimit(Integer inciteItemConsumerWinLimit) {
		this.inciteItemConsumerWinLimit = inciteItemConsumerWinLimit;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getConsumerDrawLimit() {
		return consumerDrawLimit;
	}

	public void setConsumerDrawLimit(Integer consumerDrawLimit) {
		this.consumerDrawLimit = consumerDrawLimit;
	}

	public String getConsumerDrawLimitScope() {
		return consumerDrawLimitScope;
	}

	public void setConsumerDrawLimitScope(String consumerDrawLimitScope) {
		this.consumerDrawLimitScope = consumerDrawLimitScope;
	}

	public Integer getFreeLimit() {
		return freeLimit;
	}

	public void setFreeLimit(Integer freeLimit) {
		this.freeLimit = freeLimit;
	}

	public String getFreeLimitScope() {
		return freeLimitScope;
	}

	public void setFreeLimitScope(String freeLimitScope) {
		this.freeLimitScope = freeLimitScope;
	}

	public Integer getConsumerWinLimit() {
		return consumerWinLimit;
	}

	public void setConsumerWinLimit(Integer consumerWinLimit) {
		this.consumerWinLimit = consumerWinLimit;
	}

	public Integer getEverydayWinLimit() {
		return everydayWinLimit;
	}

	public void setEverydayWinLimit(Integer everydayWinLimit) {
		this.everydayWinLimit = everydayWinLimit;
	}

	public Integer getSwitches() {
		return switches;
	}

	public void setSwitches(Integer switches) {
		this.switches = switches;
	}

	public Integer getCreditsPrice() {
		return creditsPrice;
	}

	public void setCreditsPrice(Integer creditsPrice) {
		this.creditsPrice = creditsPrice;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getIntroduction() {
		return introduction;
	}

	public void setIntroduction(String introduction) {
		this.introduction = introduction;
	}

	public String getSubtitle() {
		return subtitle;
	}

	public void setSubtitle(String subtitle) {
		this.subtitle = subtitle;
	}

	public Integer getMainItemMinComein() {
		return mainItemMinComein;
	}

	public void setMainItemMinComein(Integer mainItemMinComein) {
		this.mainItemMinComein = mainItemMinComein;
	}

	public Integer getInciteItemMinComein() {
		return inciteItemMinComein;
	}

	public void setInciteItemMinComein(Integer inciteItemMinComein) {
		this.inciteItemMinComein = inciteItemMinComein;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}
}
