package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.domain.vo.PaginationVO;
import cn.com.duiba.service.item.domain.dataobject.ItemClassifyDO;
import cn.com.duiba.service.item.domain.vo.ItemClassifyVO;
import java.util.List;
import java.util.Map;

/**
 * 管理员后台兑换项分类service
 */
public interface RemoteItemClassifyBackendService {

	/**
	 * 根据type查询列表
	 */
	public List<ItemClassifyDO> findAllByType(String type);
	
	/**
	 * 分页列表
	 */
	public PaginationVO<ItemClassifyVO> findItemClassifyPage(Map<String, Object> queryMap) ;

	/**
	 * 创建
	 */
	public ItemClassifyDO createByNameAndType(String name, String type) ;

	/**
	 * 更新
	 */
	public ItemClassifyDO updateByNameAndId(String name, Long id) ;

	/**
	 * 删除
	 */
	public void delete(Long id);

	/**
	 * 根据ids in
	 */
	public List<ItemClassifyDO> findAllByIds( List<Long> ids);
}
