package cn.com.duiba.service.domain;

import cn.com.duiba.wolf.utils.ClassUtils;
import cn.com.duiba.wolf.utils.NumberUtils;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

/**
 * DO基础类型 防止insert和update的错误使用
 * 
 * @author xuhengfei
 */
public abstract class BaseDO implements Serializable {

    private static final long serialVersionUID = 231235L;

    protected Boolean         toBeInsert;

    protected Boolean         toBeUpdate;

    public Boolean getToBeInsert() {
        if (toBeInsert == null) {
            toBeInsert = false;
        }
        return toBeInsert;
    }

    public Boolean getToBeUpdate() {
        if (toBeUpdate == null) {
            toBeUpdate = false;
        }
        return toBeUpdate;
    }

    public void setToBeInsert(Boolean toBeInsert) {
        this.toBeInsert = toBeInsert;
    }

    public void setToBeUpdate(Boolean toBeUpdate) {
        this.toBeUpdate = toBeUpdate;
    }

    /**
     * 此静态代码块用于检查domain类是否实现了Seriaiizable。domain类必须实现Serializable,这样才能被序列化反序列化
     */
    static{
        List<String> pkgNames = new ArrayList<String>();
        pkgNames.add("cn.com.duiba.service.domain");
        pkgNames.add("cn.com.duiba.service.item.domain");
        for(String pkgName : pkgNames) {
            List<Class<?>> classes = ClassUtils.getClassList("cn.com.duiba.service.domain", true, null);
            for(Class<?> clazz : classes){
                String csn = clazz.getName();
                if(Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()){
                    continue;
                } else if(csn.contains("$") && NumberUtils.isNumeric(csn.substring(csn.lastIndexOf("$") + 1))){
                    //类名以$1、$2等数字结尾是匿名内部类。
                    continue;
                } else if(!(Serializable.class.isAssignableFrom(clazz))){
                    throw new RuntimeException("class: ["+clazz.getName()+"] must implements Serializable");
                }
            }
        }
    }

}
