package cn.com.duiba.service.item.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.*;

/**
 * Class : 兑吧专题活动DO
 * 
 * @datetime 2014年11月18日 上午10:55:46
 * @author guoyanfei
 */
public class DuibaActivityDO extends BaseDO {
	private static final long serialVersionUID = -677476486584742546L;

	public static final Integer LAYOUT_ONE = 1; // 单行布局
	public static final Integer LAYOUT_TWO = 2; // 双列布局

	public static final Integer SWITCHES_DIRECT = 0; // 定向发放
	public static final Integer SWITCHES_DEV_BLACKLIST = 1; // 黑名单商品

	public static final Integer STATUS_UNPUBLISH = 0; // 未发布
	public static final Integer STATUS_STARTUP = 1; // 开启
	public static final Integer STATUS_SHUTDOWN = 2; // 关闭

	public static final Integer TYPE_ACTIVITY = 0;// 专题活动 警告：后期扩展不要用 1 ， 1已被
													// 大转盘活动表占领啦

	public static final Integer PUSH = 1;	// 主推
	public static final Integer NOT_PUSH = 0;	// 非主推

	private Long id;

	private String title; // 标题
	
	private String subtitle;//入口说明文字

	private String logo; // 以兑换项展示的时候的logo

	private String smallImage;

	private String whiteImage; //白底缩略图

	private String indexBannerImage; // 首页banner

	private String topicBannerImage; // 专题也头部banner

	private String cssUrl; // 样式表

	private Integer layout; // 布局，1单行布局， 2双列布局

	private String areasImagesItems; // 分隔图片，兑换项

	private Integer type; // 活动类型

	private String rule; // 活动规则

	private Integer status; // 开启关闭发布状态 0未发布， 1开启，2关闭

	private Integer activityOrderQuantity; // 活动订单数量

	private Boolean deleted;

	private Date gmtCreate;

	private Date gmtModified;

	private Integer switches; // 定向发放开关 第0位 1开启 0关闭
	
	private Date autoOffDate; //定时自动下架日期
	
	private String recommendImage; // 推荐位横幅图

	public DuibaActivityDO() {
	}

	public DuibaActivityDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public DuibaActivityDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			this.status = 0;
			this.activityOrderQuantity = 0;
			this.deleted = false;
			this.type = 0;
			this.switches = 0;
			this.gmtCreate = new Date();
			this.gmtModified = gmtCreate;
		}
	}

	public void openSwitch(int s) {
		int v = 1 << s;
		switches = switches | v;
	}

	public void closeSwitch(int s) {
		int v = 1 << s;
		v = ~v;
		switches = switches & v;
	}

	public boolean isOpenSwitch(int s) {
		int v = 1 << s;
		int ret = switches & v;
		return ret != 0;
	}

	@Override
	public String toString() {
		return "DuibaActivityDO [id=" + id + ", title=" + title + "]";
	}

	public Integer getSwitches() {
		return switches;
	}

	public void setSwitches(Integer switches) {
		this.switches = switches;
	}

	public Long getId() {
		return id;
	}

	public String getSubtitle() {
		return subtitle;
	}

	public void setSubtitle(String subtitle) {
		this.subtitle = subtitle;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getIndexBannerImage() {
		return indexBannerImage;
	}

	public void setIndexBannerImage(String indexBannerImage) {
		this.indexBannerImage = indexBannerImage;
	}

	public String getTopicBannerImage() {
		return topicBannerImage;
	}

	public void setTopicBannerImage(String topicBannerImage) {
		this.topicBannerImage = topicBannerImage;
	}

	public String getCssUrl() {
		return cssUrl;
	}

	public void setCssUrl(String cssUrl) {
		this.cssUrl = cssUrl;
	}

	public Integer getLayout() {
		return layout;
	}

	public void setLayout(Integer layout) {
		this.layout = layout;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getAreasImagesItems() {
		return areasImagesItems;
	}

	public void setAreasImagesItems(String areasImagesItems) {
		this.areasImagesItems = areasImagesItems;
	}

	public String getRule() {
		return rule;
	}

	public void setRule(String rule) {
		this.rule = rule;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getActivityOrderQuantity() {
		return activityOrderQuantity;
	}

	public void setActivityOrderQuantity(Integer activityOrderQuantity) {
		this.activityOrderQuantity = activityOrderQuantity;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}
	
	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}



	/**
	 * @ClassName: OperActivityArea
	 * @Description: 兑换区域
	 * @author GuoYF
	 * @date 2014年11月18日 下午7:13:36
	 */
	public class DuibaActivityArea {

		private String image;

		private List<Long> itemIds;

		private List<Integer> pushs;

		public String getImage() {
			return image;
		}

		public void setImage(String image) {
			this.image = image;
		}

		public List<Long> getItemIds() {
			return itemIds;
		}

		public void setItemIds(List<Long> itemIds) {
			this.itemIds = itemIds;
		}

		public List<Integer> getPushs() {
			return pushs;
		}

		public void setPushs(List<Integer> pushs) {
			this.pushs = pushs;
		}

		public DuibaActivityArea() {
		}

		@Override
		public String toString() {
			return "DuibaActivityArea [image=" + image + ", itemIds=" + itemIds + ", pushs=" + pushs + "]";
		}

	}

	/**
	 * @Title: getOperActivityAreaList
	 * @Description: 根据areasImagesItems获取List<DuibaActivityArea>
	 * @param areasImagesItems
	 */
	public List<DuibaActivityArea> getDuibaActivityAreaList() {
		if (StringUtils.isBlank(areasImagesItems)) {
			return null;
		}
		List<DuibaActivityArea> list = new ArrayList<DuibaActivityArea>();
		JSONObject o = JSON.parseObject(areasImagesItems);
		for (int i = 1; i <= o.size(); i++) {
			DuibaActivityArea a = new DuibaActivityArea();
			JSONObject tmp = JSON.parseObject(o.getString(String.valueOf(i)));
			a.setImage(tmp.getString("image"));
			List<Long> b = new ArrayList<Long>();
			List<Integer> c = new ArrayList<Integer>();
			for (int j = 0; j < tmp.getJSONArray("items").size(); j++) {
				JSONObject t = (JSONObject) tmp.getJSONArray("items").get(j);
				b.add(t.getLong("itemId"));
				c.add(t.getInteger("push"));
			}
			a.setItemIds(b);
			a.setPushs(c);
			list.add(a);
		}
		return list;
	}

	/**
	 * @Title: getAreasJSONString
	 * @Description: 获取areasImagesItems用于存储的字符串
	 * @param indexs
	 * @param images
	 * @param items
	 */
	public static String getAreasJSONString(List<Integer> indexs, List<String> images, List<String> items, List<String> pushButtons) {
		if (indexs == null || images == null || items == null || pushButtons == null) {
			throw new RuntimeException("兑换区域数据错误");
		}
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		for (int i = 0; i < indexs.size(); i++) {
			buffer.append("\"" + indexs.get(i) + "\"");
			buffer.append(":{\"image\":");
			buffer.append("\"" + images.get(i) + "\"");
			buffer.append(",\"items\":[");
			String tmp = items.get(i);
			String pbt = pushButtons.get(i);
			if (StringUtils.isNotBlank(tmp)) {
				String[] ii = tmp.split(",");
				String[] pp = pbt.split(",");
				for (int j = 0; j < ii.length; j++) {
					buffer.append("{\"itemId\":");
					buffer.append(ii[j]);
					buffer.append(", \"push\":");
					buffer.append(pp[j]);
					buffer.append("}");
					if (j < (ii.length - 1)) {
						buffer.append(",");
					}
				}
			}
			buffer.append("]}");
			if (i < (indexs.size() - 1)) {
				buffer.append(",");
			}
		}
		buffer.append("}");
		return buffer.toString();
	}

	/**
	 * @Title: getAreasJSONString
	 * @Description: 获取areasImagesItems用于存储的字符串
	 * @param areaImage
	 * @param areaItems
	 * @return
	 */
	public static String getAreasJSONString(Object areaImage, Object areaItems, Object pushButton) {
		String[] areaImages = null;
		String[] areaItemss = null;
		String[] pushButtons = null;

		// 判断是否只有一个区域
		if ("String".equals(areaImage.getClass().getSimpleName())) {
			String[] tmp = {(String) areaImage};
			areaImages = tmp;
		} else {
			areaImages = (String[]) areaImage;
		}
		if ("String".equals(areaItems.getClass().getSimpleName())) {
			String[] tmp = {(String) areaItems};
			areaItemss = tmp;
		} else {
			areaItemss = (String[]) areaItems;
		}
		if ("String".equals(pushButton.getClass().getSimpleName())) {
			String[] tmp = {(String) pushButton};
			pushButtons = tmp;
		} else {
			pushButtons = (String[]) pushButton;
		}

		List<String> areaImagesList = new ArrayList<String>(Arrays.asList(areaImages));
		List<String> areaItemssList = new ArrayList<String>(Arrays.asList(areaItemss));
		List<String> pushButtonsList = new ArrayList<String>(Arrays.asList(pushButtons));

		// 删除空区域
		Iterator<String> i1 = areaImagesList.iterator();
		Iterator<String> i2 = areaItemssList.iterator();
		while (i1.hasNext() && i2.hasNext()) {
			String e1 = i1.next();
			String e2 = i2.next();
			if (StringUtils.isBlank(e1) && StringUtils.isBlank(e2)) {
				i1.remove();
				i2.remove();
			}
		}

		// 获取区域序列
		List<Integer> indexs = new ArrayList<Integer>();
		for (int i = 1; i <= areaImagesList.size(); i++) {
			indexs.add(i);
		}

		return getAreasJSONString(indexs, areaImagesList, areaItemssList, pushButtonsList);
	}

	/**
	 * @Title: ifItemIdInActivity
	 * @Description: 判断itemId是否被Activity被引用
	 * @param itemId
	 * @return
	 */
	public boolean ifItemIdInActivity(Long itemId) {
		if (StringUtils.isBlank(areasImagesItems)) {
			throw new RuntimeException("无兑换项");
		}
		JSONObject o = JSON.parseObject(areasImagesItems);
		for (int i = 1; i <= o.size(); i++) {
			JSONObject tmp = JSON.parseObject(o.getString(String.valueOf(i)));
			for (int j = 0; j < tmp.getJSONArray("items").size(); j++) {
				JSONObject t = (JSONObject) tmp.getJSONArray("items").get(j);
				if (itemId.equals(t.getLong("itemId"))) {
					return true;
				}
			}
		}
		return false;
	}

	public static Long getOperatingActivityId(Long itemId, String ids) {
		JSONObject json = JSON.parseObject(ids);
		for (String key : json.keySet()) {
			JSONArray array = json.getJSONObject(key).getJSONArray("items");
			for (int i = 0; i < array.size(); i++) {
				Long ii = array.getLong(i);
				if (itemId.equals(ii)) {
					return Long.valueOf(key);
				}
			}
		}
		return null;
	}

	/**
	 * @Title: getActivityItemIds
	 * @Description: 获取活动中的所有itemId 以45,46,47,48,55,56,57,65,66这样的形式返回
	 * @return
	 */
	public String getActivityItemIds() {
		if (StringUtils.isBlank(areasImagesItems)) {
			return null;
		}
		JSONObject o = JSON.parseObject(areasImagesItems);
		StringBuffer buffer = new StringBuffer();
		for (int i = 1; i <= o.size(); i++) {
			JSONObject tmp = JSON.parseObject(o.getString(String.valueOf(i)));
			int size = tmp.getJSONArray("items").size();
			for (int j = 0; j < size; j++) {
				JSONObject t = (JSONObject) tmp.getJSONArray("items").get(j);
				buffer.append(t.getLong("itemId"));
				buffer.append(",");
			}
		}
		String result = buffer.toString();
		return result.substring(0, result.length() != 0 ? (result.length() - 1) : 0);
	}

	/**
	 * @Title: getActivityItemIdList
	 * @Description: 获取活动中的所有itemId 以数组的形式返回
	 * @return
	 */
	public List<Long> getActivityItemIdList() {
		if (StringUtils.isBlank(areasImagesItems)) {
			return null;
		}
		JSONObject o = JSON.parseObject(areasImagesItems);
		List<Long> idList = new ArrayList<Long>();
		for (int i = 1; i <= o.size(); i++) {
			JSONObject tmp = JSON.parseObject(o.getString(String.valueOf(i)));
			int size = tmp.getJSONArray("items").size();
			for (int j = 0; j < size; j++) {
				JSONObject t = (JSONObject) tmp.getJSONArray("items").get(j);
				idList.add(t.getLong("itemId"));
			}
		}
		return idList;
	}

	/**
	 * 获取兑换项/单品 itemId push 的map
	 */
	public Map<Long, Integer> getDuibaActivityItemPushMap() {
		if (StringUtils.isBlank(areasImagesItems)) {
			return null;
		}
		Map<Long, Integer> map = new HashMap<Long, Integer>();
		JSONObject o = JSON.parseObject(areasImagesItems);
		for (int i = 1; i <= o.size(); i++) {
			JSONObject tmp = JSON.parseObject(o.getString(String.valueOf(i)));
			for (int j = 0; j < tmp.getJSONArray("items").size(); j++) {
				JSONObject t = (JSONObject) tmp.getJSONArray("items").get(j);
				Integer push = t.getInteger("push");
				if (push == null) {
					push = NOT_PUSH;
				}
				Integer val = map.get(t.getLong("itemId"));
				if (val == null) {
					map.put(t.getLong("itemId"), (push == PUSH ? PUSH : NOT_PUSH));
				} else if (val == NOT_PUSH) {
					if (push == PUSH) {
						map.put(t.getLong("itemId"), push);
					}
				}
			}
		}
		return map;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public String getRecommendImage() {
		return recommendImage;
	}

	public void setRecommendImage(String recommendImage) {
		this.recommendImage = recommendImage;
	}
}
