package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppSingleLotteryDO;
import cn.com.duiba.service.exception.BusinessException;

import java.util.List;

/**
 * 单品抽奖业务DAO
 */
public interface RemoteSingleLotteryService {

	//以下方法来自 SingleLotterySimpleDAO

	/**
	 * 根据ID查询
	 */
	public AppSingleLotteryDO find(Long id);
	
	/**
	 * useless
	 * 根据ID集合查询开发者单品抽奖
	 */
	public List<AppSingleLotteryDO> findAllByIds(List<Long> ids);

	//以下方法来自 AppSingleLotteryStatusChangeDAO

	/**
	 * 增加主奖品的数量
	 */
	public int addMainAppItemRemainingById(Long id, Integer addMainAppItemRemaining);

	/**
	 * 减少主奖品的数量
	 */
	public int subMainAppItemRemainingById(Long id, Integer subMainAppItemRemaining);


	//以下方法来自SingleLotteryTextChangeDAO


	/**
	 * useless
	 * 新增开发者单品抽奖
	 */
	public AppSingleLotteryDO insert(AppSingleLotteryDO appSingleLotteryDO);

	/**
	 * useless
	 * 根据ID修改
	 */
	public int update(AppSingleLotteryDO appSingleLotteryDO);

	/**
	 * 减主奖品剩余个数
	 */
	public int reduceMainAppItemRemaining(Long id);

	/**
	 * 加主奖品剩余个数
	 */
	public int addMainAppItemRemaining(Long id);

	/**
	 * useless
	 * 开发者后台更新
	 */
	public int updateForDevEdit(AppSingleLotteryDO appSingleLottery);

	//from DevAppSingleLotteryManager from developer

	/**
	 * 更新单品抽奖的奖项库存
	 */
	public void updateMainAppItemRemainingByEdit(Long appSingleLotteryId, Integer preRemaining, Integer requiredRemaining) throws BusinessException;


	/**
	 * 创建
	 */
	public void createSingleLottery(AppSingleLotteryDO asl);

	/**
	 * updateSingleLotteryAndUpdateMainAppItemRemainingByEdit这个方法是把remoteSingleLotteryService.updateSingleLottery(asl);和remoteSingleLotteryService.updateMainAppItemRemainingByEdit(asl.getId(), preMainAppItemRemaining, remainingNum);集成到一个方法中,以支持事务
	 *AppSingleLotteryCtrl中原来没有此方法,是合成的,来自AppSingleLotteryCtrl.update
	 * @param asl
	 * @param preMainAppItemRemaining
	 * @param remainingNum
	 * @throws BusinessException
     */
	public void updateSingleLotteryAndUpdateMainAppItemRemainingByEdit(AppSingleLotteryDO asl, Integer preMainAppItemRemaining, Integer remainingNum) throws BusinessException;
}
