package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppLayoutBrickDO;
import com.google.common.base.Optional;

import java.util.List;
import java.util.Map;

public interface RemoteAppLayoutBrickService {
	/**
	 * 根据ID获取一个模版片段
	 * 建议使用findWithSimple（），如要获取皮肤的代码，用getBrickContentById()
	 * @param id 
	 * @author 刘瑶
	 */
	@Deprecated
	public AppLayoutBrickDO find(Long id);
	
	/**
	 * 根据ID获取一个模版片段，不含content字段
	 * @param id 
	 * @author 刘瑶
	 */
	public AppLayoutBrickDO findWithSimple(Long id);
	/**
	 * 新建一个模版片段
	 * @param appLayoutBrick
	 * @author 刘瑶
	 */
	public int insert(AppLayoutBrickDO appLayoutBrick);
	/**
	 * 找出所有的系统模版，不含content字段
	 * @author 刘瑶
	 */
	public List<AppLayoutBrickDO> findAllShowSystemBrickWithSimple();
	/**
	 * 找出该AppId找出所有的定制主题
	 * @param appId
	 * @author 刘瑶
	 */
	public List<AppLayoutBrickDO> findDingzhiThemeWithSimple(Long appId);
	/**
	 * 获取皮肤代码
	 * @param brickId
	 * @return
	 */
	public String getBrickContentById(Long brickId);


	//Admin
	/**
	 * 获取所有的系统模板和模板总数
	 * @param position
	 * @return
	 */
	public List<AppLayoutBrickDO> getAllSystemLayoutBrickWithSimple(Map<String, Object> params);

	public Long getAllSystemLayoutCount();
	/**
	 * 获取所有的定制模板和模板总数
	 * @param params
	 * @return
	 */
	public List<AppLayoutBrickDO> getCustomLayoutBrickWithSimple(Map<String, Object> params);
	/**
	 * 如果不指定appId,则查找所有的定制皮肤的数目
	 * @param appId
	 * @return
	 */
	public Long getCustomLayoutCount(Long appId);
	/**
	 * 更新模块的权重
	 * @param brickId
	 * @param payload
	 * @return
	 */
	public int updateLayoutBrickPayload(Optional<Long> id, Optional<Integer> payload);
	/**
	 * 更新模块的状态(是否能够被开发者看到)
	 * @param brickId
	 * @param state
	 * @return
	 */
	public int updateLayoutBrickShowStatus(Optional<Long> id, Optional<Integer> status);
	/**
	 *
	 * @param brick
	 * @return
	 */
	public int updateBrick(AppLayoutBrickDO brick);
	/**
	 * 逻辑删除一个模块(给管理员使用)
	 * @param brickId
	 * @param deleted
	 * @return
	 */
	public int updateBrickDelete(Optional<Long> id);

}
