package cn.com.duiba.service.remoteservice;

import cn.com.duiba.wolf.dubbo.DubboResult;

public interface RemoteExchangeLimitService {
	
	/**
	 * selectExchangeLimit:直充类奖品防刷验证.
	 *
	 * @author guoeryang
	 * @param appId				应用id									not null
	 * @param operatingActivityId	 活动id								not null
	 * @param consumerId			用户id									not null
	 * @param type				 奖品类型									not null
	 * @param account			   领奖账号									not null
	 * @return
	 * @since JDK 1.6
	*/
	public DubboResult<Long> checkExchangeLimit(Long appId, Long operatingActivityId, String type, String account);

	   /**
	* selectExchangeLimit:直充类奖品防刷验证记录创建.
	*
	* @author guoeryang
	* @param appId				应用id									not null
	* @param operatingActivityId	 活动id								not null
	* @param consumerId			用户id									not null
	* @param type				 奖品类型									not null
	* @param account			   领奖账号									not null
	* @return
	* @since JDK 1.6
	*/
	public void createExchangeLimitRecord(Long appId, Long operatingActivityId, Long consumerId, String type, String account);

	/**
	* selectExchangeLimit:直充类奖品防刷  用户与账户 绑定关系解除.
	*
	* @author guoeryang
	* @param type				 奖品类型									not null
	* @param appId				应用id									not null
	* @param operatingActivityId	 活动id									not null
	* @param account			   领奖账号										not null
	* @return
	* @since JDK 1.6
	*/
	public void dataBackExchangeLimit(Long appId,String type,Long operatingActivityId, String account);

}
